/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.model.vc;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public class MetadataReference {
    private String id;
    private String type;
    private final Map<String, Object> extensibleProperties = new LinkedHashMap<String, Object>();

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getExtensibleProperties() {
        return this.extensibleProperties;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", this.id);
        map.put("type", this.type);
        map.putAll(this.extensibleProperties);
        return map;
    }

    private MetadataReference() {
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private final MetadataReference reference = new MetadataReference();

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder id(String id) {
            this.reference.id = id;
            return this;
        }

        public Builder type(String type) {
            this.reference.type = type;
            return this;
        }

        @JsonAnySetter
        public Builder setExtensibleProperty(String key, Object value) {
            this.reference.extensibleProperties.put(key, value);
            return this;
        }

        public MetadataReference build() {
            Objects.requireNonNull(this.reference.id, "id");
            Objects.requireNonNull(this.reference.type, "type");
            return this.reference;
        }

        private Builder() {
        }
    }
}

