/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.model.did;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class VerificationMethod {
    private final Map<String, Object> publicKeyJwk = new LinkedHashMap<String, Object>();
    private String id;
    private String type;
    private String controller;
    private String publicKeyMultibase;

    public String getPublicKeyMultibase() {
        return this.publicKeyMultibase;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getController() {
        return this.controller;
    }

    public Map<String, Object> getPublicKeyJwk() {
        return this.publicKeyJwk;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private final VerificationMethod method = new VerificationMethod();

        private Builder() {
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder id(String id) {
            this.method.id = id;
            return this;
        }

        public Builder type(String type) {
            this.method.type = type;
            return this;
        }

        public Builder controller(String controller) {
            this.method.controller = controller;
            return this;
        }

        public Builder publicKeyJwk(Map<String, Object> jwk) {
            this.method.publicKeyJwk.putAll(jwk);
            return this;
        }

        public Builder publicKeyMultibase(String publicKeyMultibase) {
            this.method.publicKeyMultibase = publicKeyMultibase;
            return this;
        }

        public VerificationMethod build() {
            return this.method;
        }
    }
}

