/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.model.did;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.dataspacetck.dcp.system.model.ExtensibleModel;
import org.eclipse.dataspacetck.dcp.system.model.did.ServiceEntry;
import org.eclipse.dataspacetck.dcp.system.model.did.VerificationMethod;
import org.eclipse.dataspacetck.dcp.system.service.Result;

@JsonDeserialize(builder=Builder.class)
public class DidDocument
extends ExtensibleModel {
    private String id;
    @JsonProperty(value="service")
    private List<ServiceEntry> services = new ArrayList<ServiceEntry>();
    @JsonProperty(value="verificationMethod")
    private List<VerificationMethod> verificationMethods = new ArrayList<VerificationMethod>();

    private DidDocument() {
    }

    public String getId() {
        return this.id;
    }

    public List<ServiceEntry> getServices() {
        return this.services;
    }

    public List<VerificationMethod> getVerificationMethods() {
        return this.verificationMethods;
    }

    public ServiceEntry getServiceEntry(String type) {
        return this.services.stream().filter(s -> s.type().equals(type)).findFirst().orElseThrow(() -> new IllegalArgumentException("No service found for type " + type));
    }

    public Result<VerificationMethod> getVerificationMethod(String id) {
        return this.verificationMethods.stream().filter(m -> m.getId().equals(id) || m.getId().equals(this.id + id) || m.getId().equals(this.id + "#" + id)).findFirst().map(Result::success).orElseGet(() -> Result.failure("No verification method found for id " + id));
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends ExtensibleModel.Builder<Builder> {
        private final DidDocument document = new DidDocument();

        private Builder() {
            this.setModel(this.document);
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder id(String id) {
            this.document.id = id;
            return this;
        }

        public Builder service(List<ServiceEntry> services) {
            this.document.services.addAll(services);
            return this;
        }

        public Builder verificationMethod(List<VerificationMethod> methods) {
            this.document.verificationMethods.addAll(methods);
            return this;
        }

        public DidDocument build() {
            Objects.requireNonNull(this.document.id, "id");
            return this.document;
        }
    }
}

