/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.did;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.eclipse.dataspacetck.dcp.system.model.did.DidDocument;

public class DidClient {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String DID_SCHEME = "did";
    private static final String DID_WEB_PREFIX = "web:";
    private static final String DID_DOCUMENT = "did.json";
    private static final String WELL_KNOWN = "/.well-known";
    private final String scheme;

    public DidClient(boolean https) {
        this.scheme = https ? "https" : "http";
    }

    public DidDocument resolveDocument(String did) {
        DidDocument didDocument;
        block9: {
            Request request = new Request.Builder().url(this.didToUrl(did)).build();
            OkHttpClient client = new OkHttpClient();
            Call call = client.newCall(request);
            Response response = call.execute();
            try {
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected response: " + response.code());
                }
                didDocument = (DidDocument)MAPPER.readValue(response.body().string(), DidDocument.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return didDocument;
    }

    public String didToUrl(String did) {
        URL identifier = this.parseDid(did);
        Object url = identifier.toString();
        if (identifier.getPath().isEmpty()) {
            url = (String)url + WELL_KNOWN;
        }
        return URLDecoder.decode((String)url + "/did.json", StandardCharsets.UTF_8);
    }

    private URL parseDid(String did) {
        URI uri = URI.create(did);
        if (!DID_SCHEME.equalsIgnoreCase(uri.getScheme())) {
            throw new IllegalArgumentException("Unsupported DID scheme: " + uri.getScheme());
        }
        String part = uri.getRawSchemeSpecificPart();
        if (!part.startsWith(DID_WEB_PREFIX)) {
            throw new IllegalArgumentException("Invalid DID format, the URN must specify the 'web' DID Method: " + did);
        }
        if (part.endsWith(":")) {
            throw new IllegalArgumentException("Invalid DID format, the URN must not end with ':': " + did);
        }
        String host = part.substring(DID_WEB_PREFIX.length()).replace(':', '/');
        try {
            return new URL(this.scheme + "://" + host);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

