/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.Ed25519Verifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.crypto.bc.BouncyCastleProviderSingleton;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jose.jwk.gen.RSAKeyGenerator;
import com.nimbusds.jose.util.Base64URL;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.EdECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.EdECPoint;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class Keys {
    private static final int KEY_SIZE = 2048;
    private static final String ALGORITHM_EC = "ec";
    private static final String ALGORITHM_ECDSA = "ecdsa";
    private static final String ALGORITHM_EDDSA = "eddsa";
    private static final String ALGORITHM_ED25519 = "ed25519";
    private static final String ALGORITHM_RSA = "rsa";

    public static RSAKey generateRsaKey() {
        try {
            return (RSAKey)new RSAKeyGenerator(2048).keyID(UUID.randomUUID().toString()).keyUse(KeyUse.SIGNATURE).generate();
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
    }

    public static ECKey generateEcKey() {
        try {
            return (ECKey)new ECKeyGenerator(Curve.P_256).keyID(UUID.randomUUID().toString()).keyUse(KeyUse.SIGNATURE).generate();
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
    }

    public static JWSVerifier createVerifier(PublicKey publicKey) {
        String algorithm = publicKey.getAlgorithm().toLowerCase();
        try {
            return switch (algorithm) {
                case ALGORITHM_EC, ALGORITHM_ECDSA -> Keys.createEcdsaVerifier((ECPublicKey)publicKey);
                case ALGORITHM_EDDSA, ALGORITHM_ED25519 -> Keys.createEdDsaVerifier(publicKey);
                case ALGORITHM_RSA -> new RSASSAVerifier((RSAPublicKey)publicKey);
                default -> throw new IllegalArgumentException("Unsupported algorithm: " + algorithm);
            };
        }
        catch (JOSEException e) {
            throw new RuntimeException("Error creating verifier for: " + algorithm, e);
        }
    }

    public static ECDSAVerifier createEcdsaVerifier(ECPublicKey publicKey) throws JOSEException {
        ECDSAVerifier verifier = new ECDSAVerifier(publicKey);
        verifier.getJCAContext().setProvider(BouncyCastleProviderSingleton.getInstance());
        return verifier;
    }

    public static Ed25519Verifier createEdDsaVerifier(PublicKey publicKey) throws JOSEException {
        EdECPublicKey edKey = (EdECPublicKey)publicKey;
        Curve curve = Curve.parse((String)edKey.getParams().getName());
        Base64URL encodedX = Keys.encodePublicKey(edKey.getPoint());
        OctetKeyPair keyPair = new OctetKeyPair.Builder(curve, encodedX).build();
        return new Ed25519Verifier(keyPair);
    }

    @NotNull
    private static Base64URL encodePublicKey(EdECPoint point) {
        byte[] bytes = Keys.reverse(point.getY().toByteArray());
        if (point.isXOdd()) {
            int mask = -128;
            int n = bytes.length - 1;
            bytes[n] = (byte)(bytes[n] ^ mask);
        }
        return Base64URL.encode((byte[])bytes);
    }

    private static byte[] reverse(byte[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            byte temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
        return array;
    }
}

