/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.sql.assetindex.schema;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.dataspaceconnector.spi.query.QuerySpec;
import org.eclipse.dataspaceconnector.spi.result.AbstractResult;
import org.eclipse.dataspaceconnector.sql.assetindex.schema.AssetStatements;
import org.eclipse.dataspaceconnector.sql.dialect.BaseSqlDialect;
import org.eclipse.dataspaceconnector.sql.translation.SqlConditionExpression;
import org.eclipse.dataspaceconnector.sql.translation.SqlQueryStatement;

public class BaseSqlDialectStatements
implements AssetStatements {
    @Override
    public String getInsertAssetTemplate() {
        return String.format("INSERT INTO %s (%s) VALUES (?)", this.getAssetTable(), this.getAssetIdColumn());
    }

    @Override
    public String getInsertDataAddressTemplate() {
        return String.format("INSERT INTO %s (%s, %s) VALUES (?, ?%s)", this.getDataAddressTable(), this.getDataAddressAssetIdFkColumn(), this.getDataAddressColumnProperties(), this.getFormatAsJsonOperator());
    }

    @Override
    public String getInsertPropertyTemplate() {
        return String.format("INSERT INTO %s (%s, %s, %s, %s) VALUES (?, ?, ?, ?)", this.getAssetPropertyTable(), this.getPropertyAssetIdFkColumn(), this.getAssetPropertyColumnName(), this.getAssetPropertyColumnValue(), this.getAssetPropertyColumnType());
    }

    @Override
    public String getCountAssetByIdClause() {
        return String.format("SELECT COUNT(*) AS %s FROM %s WHERE %s = ?", this.getCountVariableName(), this.getAssetTable(), this.getAssetIdColumn());
    }

    @Override
    public String getFindPropertyByIdTemplate() {
        return String.format("SELECT * FROM %s WHERE %s = ?", this.getAssetPropertyTable(), this.getPropertyAssetIdFkColumn());
    }

    @Override
    public String getFindDataAddressByIdTemplate() {
        return String.format("SELECT * FROM %s WHERE %s = ?", this.getDataAddressTable(), this.getDataAddressAssetIdFkColumn());
    }

    @Override
    public String getSelectAssetTemplate() {
        return String.format("SELECT * FROM %s AS a", this.getAssetTable());
    }

    @Override
    public String getDeleteAssetByIdTemplate() {
        return String.format("DELETE FROM %s WHERE %s = ?", this.getAssetTable(), this.getAssetIdColumn());
    }

    @Override
    public String getCountVariableName() {
        return "COUNT";
    }

    @Override
    public String getQuerySubSelectTemplate() {
        return String.format("EXISTS (SELECT 1 FROM %s WHERE %s = a.%s AND %s = ? AND %s", this.getAssetPropertyTable(), this.getPropertyAssetIdFkColumn(), this.getAssetIdColumn(), this.getAssetPropertyColumnName(), this.getAssetPropertyColumnValue());
    }

    @Override
    public String getFormatAsJsonOperator() {
        return BaseSqlDialect.getJsonCastOperator();
    }

    @Override
    public SqlQueryStatement createQuery(QuerySpec querySpec) {
        List conditions = querySpec.getFilterExpression().stream().map(SqlConditionExpression::new).collect(Collectors.toList());
        List results = conditions.stream().map(SqlConditionExpression::isValidExpression).collect(Collectors.toList());
        if (results.stream().anyMatch(AbstractResult::failed)) {
            String message = results.stream().flatMap(r -> r.getFailureMessages().stream()).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(message);
        }
        List<String> subSelects = conditions.stream().map(this::toSubSelect).collect(Collectors.toList());
        String query = this.getSelectAssetTemplate() + " " + this.concatSubSelects(subSelects);
        List<String> params = conditions.stream().flatMap(SqlConditionExpression::toStatementParameter).collect(Collectors.toList());
        SqlQueryStatement stmt = new SqlQueryStatement(query);
        params.forEach(arg_0 -> ((SqlQueryStatement)stmt).addParameter(arg_0));
        stmt.addParameter((Object)querySpec.getLimit());
        stmt.addParameter((Object)querySpec.getOffset());
        return stmt;
    }

    private String concatSubSelects(List<String> subSelects) {
        if (subSelects.isEmpty()) {
            return "";
        }
        return String.format(" WHERE %s", String.join((CharSequence)" AND ", subSelects));
    }

    private String toSubSelect(SqlConditionExpression c) {
        return String.format("%s %s %s)", this.getQuerySubSelectTemplate(), c.getCriterion().getOperator(), c.toValuePlaceholder());
    }
}

