/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.sql.assetindex;

import org.eclipse.dataspaceconnector.dataloading.AssetLoader;
import org.eclipse.dataspaceconnector.spi.asset.AssetIndex;
import org.eclipse.dataspaceconnector.spi.asset.DataAddressResolver;
import org.eclipse.dataspaceconnector.spi.system.Inject;
import org.eclipse.dataspaceconnector.spi.system.Provides;
import org.eclipse.dataspaceconnector.spi.system.ServiceExtension;
import org.eclipse.dataspaceconnector.spi.system.ServiceExtensionContext;
import org.eclipse.dataspaceconnector.spi.transaction.TransactionContext;
import org.eclipse.dataspaceconnector.spi.transaction.datasource.DataSourceRegistry;
import org.eclipse.dataspaceconnector.sql.assetindex.SqlAssetIndex;
import org.eclipse.dataspaceconnector.sql.assetindex.schema.AssetStatements;
import org.eclipse.dataspaceconnector.sql.assetindex.schema.postgres.PostgresDialectStatements;

@Provides(value={AssetLoader.class, AssetIndex.class, DataAddressResolver.class})
public class SqlAssetIndexServiceExtension
implements ServiceExtension {
    @Inject
    private DataSourceRegistry dataSourceRegistry;
    @Inject
    private TransactionContext transactionContext;
    @Inject(required=false)
    private AssetStatements dialect;

    public void initialize(ServiceExtensionContext context) {
        String dataSourceName = context.getConfig().getString("edc.datasource.asset.name");
        SqlAssetIndex sqlAssetLoader = new SqlAssetIndex(this.dataSourceRegistry, dataSourceName, this.transactionContext, context.getTypeManager().getMapper(), this.getDialect());
        context.registerService(AssetLoader.class, (Object)sqlAssetLoader);
        context.registerService(AssetIndex.class, (Object)sqlAssetLoader);
        context.registerService(DataAddressResolver.class, (Object)sqlAssetLoader);
    }

    private AssetStatements getDialect() {
        return this.dialect != null ? this.dialect : new PostgresDialectStatements();
    }
}

