/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspaceconnector.sql.assetindex;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.eclipse.dataspaceconnector.dataloading.AssetEntry;
import org.eclipse.dataspaceconnector.dataloading.AssetLoader;
import org.eclipse.dataspaceconnector.spi.asset.AssetIndex;
import org.eclipse.dataspaceconnector.spi.asset.AssetSelectorExpression;
import org.eclipse.dataspaceconnector.spi.asset.DataAddressResolver;
import org.eclipse.dataspaceconnector.spi.persistence.EdcPersistenceException;
import org.eclipse.dataspaceconnector.spi.query.QuerySpec;
import org.eclipse.dataspaceconnector.spi.transaction.TransactionContext;
import org.eclipse.dataspaceconnector.spi.transaction.datasource.DataSourceRegistry;
import org.eclipse.dataspaceconnector.spi.types.domain.DataAddress;
import org.eclipse.dataspaceconnector.spi.types.domain.asset.Asset;
import org.eclipse.dataspaceconnector.sql.SqlQueryExecutor;
import org.eclipse.dataspaceconnector.sql.assetindex.schema.AssetStatements;
import org.eclipse.dataspaceconnector.sql.translation.SqlQueryStatement;
import org.jetbrains.annotations.Nullable;

public class SqlAssetIndex
implements AssetLoader,
AssetIndex,
DataAddressResolver {
    private final ObjectMapper objectMapper;
    private final DataSourceRegistry dataSourceRegistry;
    private final String dataSourceName;
    private final TransactionContext transactionContext;
    private final AssetStatements assetStatements;

    public SqlAssetIndex(DataSourceRegistry dataSourceRegistry, String dataSourceName, TransactionContext transactionContext, ObjectMapper objectMapper, AssetStatements assetStatements) {
        this.dataSourceRegistry = Objects.requireNonNull(dataSourceRegistry);
        this.dataSourceName = Objects.requireNonNull(dataSourceName);
        this.transactionContext = Objects.requireNonNull(transactionContext);
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.assetStatements = Objects.requireNonNull(assetStatements);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Asset deleteById(String assetId) {
        Objects.requireNonNull(assetId);
        try (Connection connection = this.getConnection();){
            Asset asset2 = this.findById(assetId);
            if (asset2 == null) {
                Asset asset3 = null;
                return asset3;
            }
            this.transactionContext.execute(() -> SqlQueryExecutor.executeQuery((Connection)connection, (String)this.assetStatements.getDeleteAssetByIdTemplate(), (Object[])new Object[]{assetId}));
            Asset asset = asset2;
            return asset;
        }
        catch (Exception e) {
            throw new EdcPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public void accept(AssetEntry item) {
        Objects.requireNonNull(item);
        Asset asset = item.getAsset();
        DataAddress dataAddress = item.getDataAddress();
        Objects.requireNonNull(asset);
        Objects.requireNonNull(dataAddress);
        this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                try {
                    if (this.existsById(asset.getId(), connection)) {
                        throw new EdcPersistenceException(String.format("Cannot persist. Asset with ID '%s' already exists.", asset.getId()));
                    }
                    SqlQueryExecutor.executeQuery((Connection)connection, (String)this.assetStatements.getInsertAssetTemplate(), (Object[])new Object[]{asset.getId()});
                    String insertDataAddressTemplate = this.assetStatements.getInsertDataAddressTemplate();
                    SqlQueryExecutor.executeQuery((Connection)connection, (String)insertDataAddressTemplate, (Object[])new Object[]{asset.getId(), this.objectMapper.writeValueAsString((Object)dataAddress.getProperties())});
                    for (Map.Entry property : asset.getProperties().entrySet()) {
                        SqlQueryExecutor.executeQuery((Connection)connection, (String)this.assetStatements.getInsertPropertyTemplate(), (Object[])new Object[]{asset.getId(), property.getKey(), this.toPropertyValue(property.getValue()), property.getValue().getClass().getName()});
                    }
                }
                catch (JsonProcessingException e) {
                    throw new EdcPersistenceException((Throwable)e);
                }
            }
            catch (Exception e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    public Stream<Asset> queryAssets(AssetSelectorExpression expression) {
        Objects.requireNonNull(expression);
        List criteria = expression.getCriteria();
        QuerySpec querySpec = QuerySpec.Builder.newInstance().filter(criteria).offset(Integer.valueOf(0)).limit(Integer.valueOf(Integer.MAX_VALUE)).build();
        return this.queryAssets(querySpec);
    }

    public Stream<Asset> queryAssets(QuerySpec querySpec) {
        Objects.requireNonNull(querySpec);
        return (Stream)this.transactionContext.execute(() -> {
            Stream<Asset> stream;
            block8: {
                Connection connection = this.getConnection();
                try {
                    SqlQueryStatement statement = this.assetStatements.createQuery(querySpec);
                    List ids = SqlQueryExecutor.executeQuery((Connection)connection, this::mapAssetIds, (String)statement.getQueryAsString(), (Object[])statement.getParameters());
                    stream = ids.stream().map(this::findById);
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new EdcPersistenceException((Throwable)e);
                    }
                }
                connection.close();
            }
            return stream;
        });
    }

    @Nullable
    public Asset findById(String assetId) {
        Asset asset;
        block9: {
            Objects.requireNonNull(assetId);
            Connection connection = this.getConnection();
            try {
                asset = (Asset)this.transactionContext.execute(() -> {
                    if (!this.existsById(assetId, connection)) {
                        return null;
                    }
                    Map<String, Object> assetProperties = SqlQueryExecutor.executeQuery((Connection)connection, this::mapPropertyResultSet, (String)this.assetStatements.getFindPropertyByIdTemplate(), (Object[])new Object[]{assetId}).stream().collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, AbstractMap.SimpleImmutableEntry::getValue));
                    return Asset.Builder.newInstance().id(assetId).properties(assetProperties).build();
                });
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (e instanceof EdcPersistenceException) {
                        throw (EdcPersistenceException)e;
                    }
                    throw new EdcPersistenceException(e.getMessage(), (Throwable)e);
                }
            }
            connection.close();
        }
        return asset;
    }

    public DataAddress resolveForAsset(String assetId) {
        DataAddress dataAddress;
        block9: {
            Objects.requireNonNull(assetId);
            Connection connection = this.getConnection();
            try {
                List dataAddressList = (List)this.transactionContext.execute(() -> SqlQueryExecutor.executeQuery((Connection)connection, this::mapDataAddress, (String)this.assetStatements.getFindDataAddressByIdTemplate(), (Object[])new Object[]{assetId}));
                dataAddress = this.single(dataAddressList);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (e instanceof EdcPersistenceException) {
                        throw (EdcPersistenceException)e;
                    }
                    throw new EdcPersistenceException(e.getMessage(), (Throwable)e);
                }
            }
            connection.close();
        }
        return dataAddress;
    }

    int mapRowCount(ResultSet resultSet) throws SQLException {
        return resultSet.getInt(this.assetStatements.getCountVariableName());
    }

    AbstractMap.SimpleImmutableEntry<String, Object> mapPropertyResultSet(ResultSet resultSet) throws SQLException, ClassNotFoundException, JsonProcessingException {
        String name = resultSet.getString(this.assetStatements.getAssetPropertyColumnName());
        String value = resultSet.getString(this.assetStatements.getAssetPropertyColumnValue());
        String type = resultSet.getString(this.assetStatements.getAssetPropertyColumnType());
        return new AbstractMap.SimpleImmutableEntry<String, Object>(name, this.fromPropertyValue(value, type));
    }

    @Nullable
    private DataAddress single(List<DataAddress> dataAddressList) {
        if (dataAddressList.size() <= 0) {
            return null;
        }
        if (dataAddressList.size() > 1) {
            throw new IllegalStateException("Expected result set size of 0 or 1 but got " + dataAddressList.size());
        }
        return dataAddressList.iterator().next();
    }

    private Object fromPropertyValue(String value, String type) throws ClassNotFoundException, JsonProcessingException {
        Class<?> clazz = Class.forName(type);
        if (clazz == String.class) {
            return value;
        }
        return this.objectMapper.readValue(value, clazz);
    }

    private boolean existsById(String assetId, Connection connection) {
        Integer assetCount = (Integer)this.transactionContext.execute(() -> (Integer)SqlQueryExecutor.executeQuery((Connection)connection, this::mapRowCount, (String)this.assetStatements.getCountAssetByIdClause(), (Object[])new Object[]{assetId}).iterator().next());
        if (assetCount <= 0) {
            return false;
        }
        if (assetCount > 1) {
            throw new IllegalStateException("Expected result set size of 0 or 1 but got " + assetCount);
        }
        return true;
    }

    private DataSource getDataSource() {
        return Objects.requireNonNull(this.dataSourceRegistry.resolve(this.dataSourceName), String.format("DataSource %s could not be resolved", this.dataSourceName));
    }

    private Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    private DataAddress mapDataAddress(ResultSet resultSet) throws SQLException, JsonProcessingException {
        return DataAddress.Builder.newInstance().properties((Map)this.objectMapper.readValue(resultSet.getString(this.assetStatements.getDataAddressColumnProperties()), (TypeReference)new TypeReference<Map<String, String>>(){})).build();
    }

    private String mapAssetIds(ResultSet resultSet) throws SQLException {
        return resultSet.getString(this.assetStatements.getAssetIdColumn());
    }

    private String toPropertyValue(Object value) throws JsonProcessingException {
        return value instanceof String ? value.toString() : this.objectMapper.writeValueAsString(value);
    }
}

