/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.linters;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.ec4j.core.ResourceProperties;
import org.ec4j.core.model.PropertyType;
import org.ec4j.lint.api.Delete;
import org.ec4j.lint.api.Edit;
import org.ec4j.lint.api.Insert;
import org.ec4j.lint.api.Linter;
import org.ec4j.lint.api.Location;
import org.ec4j.lint.api.Logger;
import org.ec4j.lint.api.Replace;
import org.ec4j.lint.api.Resource;
import org.ec4j.lint.api.Violation;
import org.ec4j.lint.api.ViolationHandler;
import org.ec4j.linters.Indent;
import org.ec4j.linters.xml.XmlLexer;
import org.ec4j.linters.xml.XmlParser;
import org.ec4j.linters.xml.XmlParserListener;

public class XmlLinter
implements Linter {
    private static final List<String> DEFAULT_EXCLUDES = Collections.emptyList();
    private static final List<String> DEFAULT_INCLUDES = Collections.unmodifiableList(Arrays.asList("**/*.xml", "**/*.xsl"));

    public List<String> getDefaultExcludes() {
        return DEFAULT_EXCLUDES;
    }

    public List<String> getDefaultIncludes() {
        return DEFAULT_INCLUDES;
    }

    public void process(Resource resource, ResourceProperties properties, ViolationHandler violationHandler) throws IOException {
        Logger log = violationHandler.getLogger();
        PropertyType.IndentStyleValue indentStyle = (PropertyType.IndentStyleValue)properties.getValue(PropertyType.indent_style, null, false);
        Integer effectiveIndentSize = indentStyle == PropertyType.IndentStyleValue.tab ? Integer.valueOf(1) : (Integer)properties.getValue(PropertyType.indent_size, null, false);
        if (log.isTraceEnabled()) {
            log.trace("Checking indent_style value '{}' in {}", new Object[]{indentStyle, resource});
            log.trace("Checking indent_size value '{}' in {}", new Object[]{effectiveIndentSize, resource});
        }
        if (indentStyle != null || effectiveIndentSize != null) {
            if (indentStyle != null && effectiveIndentSize != null) {
                try (Reader in = resource.openReader();){
                    XmlParser parser = new XmlParser((TokenStream)new CommonTokenStream((TokenSource)new XmlLexer((CharStream)CharStreams.fromReader((Reader)in, (String)resource.toString()))));
                    XmlParser.DocumentContext rootContext = parser.document();
                    ParseTreeWalker walker = new ParseTreeWalker();
                    walker.walk((ParseTreeListener)new FormatParserListener(this, resource, indentStyle, effectiveIndentSize, violationHandler), (ParseTree)rootContext);
                }
            } else {
                log.warn(this.getClass().getName() + " expects both indent_style and indent_size to be set for file '{}'", new Object[]{resource});
            }
        }
    }

    static class FormatParserListener
    implements XmlParserListener {
        private final StringBuilder charBuffer = new StringBuilder();
        private int charBufferEndLineNumber;
        private Boolean charBufferStartsAtStartOfDocument;
        private final Resource file;
        private final char indentChar;
        private final int indentSize;
        private final PropertyType.IndentStyleValue indentStyle;
        private Indent lastIndent = Indent.START;
        private final Linter linter;
        private Deque<ElementEntry> stack = new ArrayDeque<ElementEntry>();
        private final ViolationHandler violationHandler;

        FormatParserListener(Linter linter, Resource file, PropertyType.IndentStyleValue indentStyle, int indetSize, ViolationHandler violationHandler) {
            this.linter = linter;
            this.file = file;
            this.indentStyle = indentStyle;
            this.indentChar = indentStyle.getIndentChar();
            this.indentSize = indetSize;
            this.violationHandler = violationHandler;
        }

        private void adjustIndentLength(Token start, Indent foundIndent, int expectedIndent, int columnAdjustment) {
            Insert fix;
            int opValue = expectedIndent - foundIndent.getSize();
            int len = Math.abs(opValue);
            int col = start.getCharPositionInLine() + 1 - columnAdjustment;
            if (opValue > 0) {
                fix = Insert.repeat((char)this.indentChar, (int)len);
            } else {
                fix = new Delete(len);
                col -= len;
            }
            Location loc = new Location(start.getLine(), col);
            Violation violation = new Violation(this.file, loc, (Edit)fix, this.linter, PropertyType.indent_style.getName(), this.indentStyle.name(), PropertyType.indent_size.getName(), String.valueOf(this.indentSize));
            this.violationHandler.handle(violation);
        }

        private void consumeText(ParserRuleContext ctx) {
            if (this.charBufferStartsAtStartOfDocument == null) {
                Token start = ctx.getStart();
                this.charBufferStartsAtStartOfDocument = start.getLine() == 1 && start.getCharPositionInLine() == 0;
            }
            this.charBuffer.append(ctx.getText());
            this.charBufferEndLineNumber = ctx.getStop().getLine();
        }

        @Override
        public void enterAttribute(XmlParser.AttributeContext ctx) {
        }

        @Override
        public void enterChardata(XmlParser.ChardataContext ctx) {
        }

        @Override
        public void enterComment(XmlParser.CommentContext ctx) {
        }

        @Override
        public void enterContent(XmlParser.ContentContext ctx) {
        }

        @Override
        public void enterDocument(XmlParser.DocumentContext ctx) {
        }

        @Override
        public void enterElement(XmlParser.ElementContext ctx) {
        }

        @Override
        public void enterEndName(XmlParser.EndNameContext ctx) {
            this.flushWs();
            String qName = ctx.getText();
            if (this.stack.isEmpty()) {
                Token start = ctx.getStart();
                throw new IllegalStateException("Stack must not be empty when closing the element " + qName + " around line " + start.getLine() + " and column " + (start.getCharPositionInLine() + 1));
            }
            ElementEntry startEntry = this.stack.pop();
            int expectedIndent = startEntry.expectedIndent.getSize();
            if (this.lastIndent.getLineNumber() != startEntry.foundIndent.getLineNumber()) {
                if (this.lastIndent.getBadLength() > 0) {
                    this.replaceIndentCharsAndAdjustIndentLength(expectedIndent, this.lastIndent, ctx.getStart());
                } else if (this.lastIndent.getSize() != expectedIndent) {
                    this.adjustIndentLength(ctx.getStart(), this.lastIndent, expectedIndent, 2);
                }
            }
        }

        public void enterEveryRule(ParserRuleContext ctx) {
        }

        @Override
        public void enterMisc(XmlParser.MiscContext ctx) {
        }

        @Override
        public void enterProcessingInstruction(XmlParser.ProcessingInstructionContext ctx) {
        }

        @Override
        public void enterProlog(XmlParser.PrologContext ctx) {
            this.flushWs();
        }

        @Override
        public void enterReference(XmlParser.ReferenceContext ctx) {
        }

        @Override
        public void enterSeaWs(XmlParser.SeaWsContext ctx) {
        }

        @Override
        public void enterStartEndName(XmlParser.StartEndNameContext ctx) {
            this.enterStartNameInternal(ctx, false);
        }

        @Override
        public void enterStartName(XmlParser.StartNameContext ctx) {
            this.enterStartNameInternal(ctx, true);
        }

        void enterStartNameInternal(ParserRuleContext ctx, boolean pushToStack) {
            this.flushWs();
            String qName = ctx.getText();
            ElementEntry currentEntry = new ElementEntry(qName, this.lastIndent);
            if (!this.stack.isEmpty()) {
                ElementEntry parentEntry = this.stack.peek();
                int indentDiff = currentEntry.foundIndent.getSize() - parentEntry.expectedIndent.getSize();
                int expectedIndent = parentEntry.expectedIndent.getSize() + this.indentSize;
                int badLength = this.lastIndent.getBadLength();
                if (indentDiff != 0 || currentEntry.foundIndent.getLineNumber() != parentEntry.foundIndent.getLineNumber()) {
                    if (badLength > 0) {
                        this.replaceIndentCharsAndAdjustIndentLength(expectedIndent, this.lastIndent, ctx.getStart());
                        if (pushToStack && indentDiff != this.indentSize) {
                            currentEntry = new ElementEntry(qName, this.lastIndent, new Indent(this.lastIndent.getLineNumber(), expectedIndent, -1, 0));
                        }
                    } else if (indentDiff != this.indentSize) {
                        this.adjustIndentLength(ctx.getStart(), currentEntry.foundIndent, expectedIndent, 1);
                        if (pushToStack) {
                            currentEntry = new ElementEntry(qName, this.lastIndent, new Indent(this.lastIndent.getLineNumber(), expectedIndent, -1, 0));
                        }
                    }
                }
            }
            if (pushToStack) {
                this.stack.push(currentEntry);
            }
        }

        @Override
        public void enterText(XmlParser.TextContext ctx) {
        }

        @Override
        public void exitAttribute(XmlParser.AttributeContext ctx) {
        }

        @Override
        public void exitChardata(XmlParser.ChardataContext ctx) {
        }

        @Override
        public void exitComment(XmlParser.CommentContext ctx) {
            this.flushWs();
        }

        @Override
        public void exitContent(XmlParser.ContentContext ctx) {
        }

        @Override
        public void exitDocument(XmlParser.DocumentContext ctx) {
        }

        @Override
        public void exitElement(XmlParser.ElementContext ctx) {
        }

        @Override
        public void exitEndName(XmlParser.EndNameContext ctx) {
        }

        public void exitEveryRule(ParserRuleContext ctx) {
        }

        @Override
        public void exitMisc(XmlParser.MiscContext ctx) {
        }

        @Override
        public void exitProcessingInstruction(XmlParser.ProcessingInstructionContext ctx) {
            this.flushWs();
        }

        @Override
        public void exitProlog(XmlParser.PrologContext ctx) {
            this.flushWs();
        }

        @Override
        public void exitReference(XmlParser.ReferenceContext ctx) {
        }

        @Override
        public void exitSeaWs(XmlParser.SeaWsContext ctx) {
            this.consumeText(ctx);
        }

        @Override
        public void exitStartEndName(XmlParser.StartEndNameContext ctx) {
        }

        @Override
        public void exitStartName(XmlParser.StartNameContext ctx) {
        }

        @Override
        public void exitText(XmlParser.TextContext ctx) {
            this.consumeText(ctx);
        }

        private void flushWs() {
            int indentLength = 0;
            int len = this.charBuffer.length();
            BitSet edits = null;
            int editsLength = 0;
            block4: for (int i = len - 1; i >= 0; --i) {
                char ch = this.charBuffer.charAt(i);
                switch (ch) {
                    case '\n': 
                    case '\r': {
                        this.lastIndent = Indent.of(this.charBufferEndLineNumber, indentLength, edits, editsLength);
                        this.charBuffer.setLength(0);
                        this.charBufferStartsAtStartOfDocument = null;
                        return;
                    }
                    case '\t': 
                    case ' ': {
                        if (ch != this.indentChar) {
                            if (edits == null) {
                                edits = new BitSet();
                            }
                            edits.set(editsLength);
                        }
                        if (edits != null) {
                            ++editsLength;
                        }
                        ++indentLength;
                        continue block4;
                    }
                    default: {
                        this.charBuffer.setLength(0);
                        this.charBufferStartsAtStartOfDocument = null;
                        return;
                    }
                }
            }
            if (this.charBufferStartsAtStartOfDocument != null && this.charBufferStartsAtStartOfDocument.booleanValue()) {
                this.lastIndent = Indent.of(this.charBufferEndLineNumber, indentLength, edits, editsLength);
            }
            this.charBuffer.setLength(0);
            this.charBufferStartsAtStartOfDocument = null;
        }

        private void replaceIndentCharsAndAdjustIndentLength(int expectedIndent, Indent lastIndent, Token start) {
            int column;
            Delete fix;
            int badLength = lastIndent.getBadLength();
            if (badLength == 0) {
                throw new IllegalStateException("Avoid calling replaceIndentCharsAndAdjustIndentLength() when lastIndent.getBadLength() == 0");
            }
            int diff = expectedIndent - lastIndent.getSize();
            int deletionLength = -diff;
            if (deletionLength >= 0 && deletionLength >= badLength) {
                fix = new Delete(deletionLength);
                int overflow = lastIndent.getBadStartColumn() - 1 + deletionLength - lastIndent.getSize();
                if (overflow > 0) {
                    column = lastIndent.getBadStartColumn() - overflow;
                    assert (column >= 1) : "column must be >= 1";
                } else {
                    column = lastIndent.getBadStartColumn();
                }
            } else {
                fix = Replace.indent((int)badLength, (PropertyType.IndentStyleValue)this.indentStyle, (int)(badLength + diff));
                column = lastIndent.getBadStartColumn();
            }
            Location loc = new Location(start.getLine(), column);
            Violation violation = new Violation(this.file, loc, (Edit)fix, this.linter, PropertyType.indent_style.getName(), this.indentStyle.name(), PropertyType.indent_size.getName(), String.valueOf(this.indentSize));
            this.violationHandler.handle(violation);
        }

        public void visitErrorNode(ErrorNode node) {
        }

        public void visitTerminal(TerminalNode node) {
        }

        static class LastTerminalFinder
        extends AbstractParseTreeVisitor<Object> {
            private TerminalNode lastTerminal;

            LastTerminalFinder() {
            }

            public TerminalNode getLastTerminal() {
                return this.lastTerminal;
            }

            public Object visitTerminal(TerminalNode node) {
                this.lastTerminal = node;
                return null;
            }
        }

        private static class ElementEntry {
            private final String elementName;
            private final Indent expectedIndent;
            private final Indent foundIndent;

            ElementEntry(String elementName, Indent foundIndent) {
                this.elementName = elementName;
                this.foundIndent = foundIndent;
                this.expectedIndent = foundIndent;
            }

            ElementEntry(String elementName, Indent foundIndent, Indent expectedIndent) {
                this.elementName = elementName;
                this.foundIndent = foundIndent;
                this.expectedIndent = expectedIndent;
            }

            public String toString() {
                return "<" + this.elementName + "> " + this.foundIndent;
            }
        }
    }
}

