/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.lint.api;

import java.util.Arrays;
import org.ec4j.core.model.PropertyType;
import org.ec4j.lint.api.Edit;
import org.ec4j.lint.api.LintUtils;
import org.ec4j.lint.api.Resource;

public class Insert
implements Edit {
    private final CharSequence insertion;
    private final String message;

    public static Insert endOfLine(PropertyType.EndOfLineValue eol) {
        return new Insert(eol.getEndOfLineString(), "Insert " + eol.name());
    }

    public static Insert repeat(char ch, int count) {
        String ofWhat;
        char[] insertion = new char[count];
        Arrays.fill(insertion, ch);
        switch (ch) {
            case ' ': {
                ofWhat = count == 1 ? "space" : "spaces";
                break;
            }
            case '\t': {
                ofWhat = count == 1 ? "tab" : "tabs";
                break;
            }
            default: {
                ofWhat = count == 1 ? "'" + ch + "' character" : "'" + ch + "' characters";
            }
        }
        return new Insert(new String(insertion), "Insert " + count + " " + ofWhat);
    }

    public static Insert text(String insertedText) {
        return new Insert(insertedText, "Insert '" + LintUtils.escape(insertedText) + "'");
    }

    public Insert(CharSequence insertion, String message) {
        this.insertion = insertion;
        this.message = message;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Insert other = (Insert)obj;
        if (this.insertion == null ? other.insertion != null : !this.insertion.equals(other.insertion)) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.insertion == null ? 0 : this.insertion.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    @Override
    public void perform(Resource document, int offset) {
        document.insert(offset, this.insertion);
    }
}

