/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.lint.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ec4j.core.Resource;
import org.ec4j.lint.api.FormatException;
import org.ec4j.lint.api.LineReader;
import org.ec4j.lint.api.Location;

public class Resource {
    private static final Pattern EOL_MATCHER = Pattern.compile("$", 8);
    private final Path absPath;
    private final Charset encoding;
    private int hashCodeLoaded;
    private LineIndex lineIndex;
    private final Path relPath;
    StringBuilder text;

    public Resource(Path absPath, Path relPath, Charset encoding) {
        this.absPath = absPath;
        this.relPath = relPath;
        this.encoding = encoding;
    }

    public Resource(Path absPath, Path relPath, Charset encoding, String text) {
        this(absPath, relPath, encoding);
        this.text = new StringBuilder(text);
        this.hashCodeLoaded = text.hashCode();
    }

    public boolean changed() {
        int len = this.text.length();
        int hash = 0;
        for (int i = 0; i < len; ++i) {
            hash = 31 * hash + this.text.charAt(i);
        }
        return hash != this.hashCodeLoaded;
    }

    public char charAt(int index) {
        this.ensureReadSilent();
        return this.text.charAt(index);
    }

    public void delete(int start, int end) {
        this.ensureReadSilent();
        this.text.delete(start, end);
        this.invalidateIndex();
    }

    private void ensureIndexAvailable() {
        if (this.lineIndex == null) {
            this.ensureReadSilent();
            this.lineIndex = LineIndex.of(this.text);
        }
    }

    private void ensureRead() throws IOException {
        if (this.text == null) {
            InputStream in = null;
            Reader r = null;
            try {
                int len;
                in = Resource.Bom.skipBom((InputStream)Files.newInputStream(this.absPath, new OpenOption[0]), (Charset)this.encoding);
                r = new BufferedReader(new InputStreamReader(in, this.encoding));
                int hash = 0;
                StringBuilder sb = new StringBuilder(256);
                char[] cbuf = new char[8192];
                while ((len = r.read(cbuf)) >= 0) {
                    sb.append(cbuf, 0, len);
                    for (int i = 0; i < len; ++i) {
                        hash = 31 * hash + cbuf[i];
                    }
                }
                this.text = sb;
                this.invalidateIndex();
                this.hashCodeLoaded = hash;
            }
            catch (MalformedInputException e) {
                throw new FormatException("Could not read " + this.absPath + ". This may mean that it is a binary file and you should exclude it from editorconfig processing.", e);
            }
            finally {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    private void ensureReadSilent() {
        try {
            this.ensureRead();
        }
        catch (IOException e) {
            throw new FormatException("Could not read " + this.absPath, e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
            return false;
        }
        return !(this.absPath == null ? other.absPath != null : !this.absPath.equals(other.absPath));
    }

    public int findLineStart(int lineNumber) {
        this.ensureIndexAvailable();
        return this.lineIndex.findLineStart(lineNumber);
    }

    public Location findLocation(int offset) {
        this.ensureReadSilent();
        if (offset == 0) {
            return Location.initial();
        }
        int line = 1;
        int column = 1;
        block4: for (int i = 0; i < this.text.length() && i <= offset; ++i) {
            if (i == offset) {
                return new Location(line, column);
            }
            char ch = this.text.charAt(i);
            switch (ch) {
                case '\r': {
                    if (i + 1 < this.text.length() && this.text.charAt(i + 1) == '\n' && ++i == offset) {
                        return new Location(line, column + 1);
                    }
                    ++line;
                    column = 1;
                    continue block4;
                }
                case '\n': {
                    ++line;
                    column = 1;
                    continue block4;
                }
                default: {
                    ++column;
                }
            }
        }
        return new Location(line, column);
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public Path getPath() {
        return this.absPath;
    }

    public String getText() {
        this.ensureReadSilent();
        return this.text.toString();
    }

    public CharSequence getTextAsCharSequence() {
        this.ensureReadSilent();
        return this.text;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.absPath == null ? 0 : this.absPath.hashCode());
        return result;
    }

    public void insert(int offset, CharSequence string) {
        this.ensureReadSilent();
        this.text.insert(offset, string);
        this.invalidateIndex();
    }

    private void invalidateIndex() {
        this.lineIndex = null;
    }

    public int length() {
        this.ensureReadSilent();
        return this.text.length();
    }

    public Reader openReader() throws IOException {
        this.ensureRead();
        return LineReader.of(this.text);
    }

    public void replace(int start, int end, String replacement) {
        this.ensureReadSilent();
        this.text.replace(start, end, replacement);
        this.invalidateIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws IOException {
        OutputStream out = null;
        Writer w = null;
        try {
            int srcEnd;
            out = Resource.Bom.writeBom((OutputStream)Files.newOutputStream(this.absPath, new OpenOption[0]), (Charset)this.encoding);
            w = new BufferedWriter(new OutputStreamWriter(out, this.encoding));
            char[] cbuf = new char[1024];
            int len = this.text.length();
            for (int i = 0; i < len; i += srcEnd - i) {
                srcEnd = Math.min(len, i + cbuf.length);
                this.text.getChars(i, srcEnd, cbuf, 0);
                w.write(cbuf, 0, srcEnd - i);
            }
        }
        finally {
            if (w != null) {
                w.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public CharSequence subSequence(int start, int end) {
        this.ensureReadSilent();
        return this.text.subSequence(start, end);
    }

    public String toString() {
        return this.relPath.toString();
    }

    static class LineIndex {
        final int[] lineStartOffsets;

        public static Builder builder() {
            return new Builder();
        }

        public static LineIndex of(CharSequence text) {
            Builder b = new Builder();
            int len = text.length();
            Matcher m = EOL_MATCHER.matcher(text);
            while (m.find()) {
                int end = m.end();
                if (end >= len) continue;
                switch (text.charAt(end)) {
                    case '\n': {
                        b.lineStartOffset(end + 1);
                        break;
                    }
                    case '\r': {
                        if (++end < len && text.charAt(end) == '\n') {
                            b.lineStartOffset(end + 1);
                            break;
                        }
                        b.lineStartOffset(end);
                    }
                }
            }
            return b.build();
        }

        LineIndex(int[] lineStartOffsets) {
            this.lineStartOffsets = lineStartOffsets;
        }

        public int findLineStart(int lineNumber) {
            if (lineNumber == 1) {
                return 0;
            }
            if (lineNumber < 1 && lineNumber - 2 >= this.lineStartOffsets.length) {
                throw new ArrayIndexOutOfBoundsException(String.format("Cannot access line %d, %s has only %d entries", lineNumber, LineIndex.class.getName(), this.lineStartOffsets.length + 1));
            }
            return this.lineStartOffsets[lineNumber - 2];
        }

        public Location findLocation(int offset) {
            if (offset == 0) {
                return Location.initial();
            }
            int len = this.lineStartOffsets.length;
            if (len == 0) {
                return new Location(1, offset + 1);
            }
            for (int i = 0; i < len; ++i) {
                if (this.lineStartOffsets[i] == offset) {
                    return new Location(i + 2, 1);
                }
                if (this.lineStartOffsets[i] <= offset) continue;
                if (i == 0) {
                    return new Location(1, offset + 1);
                }
                int column = offset - this.lineStartOffsets[i - 1] + 1;
                return new Location(i + 1, column);
            }
            int column = offset - this.lineStartOffsets[len - 1] + 1;
            return new Location(len + 1, column);
        }

        static class Builder {
            private static final int[] EMPTY = new int[0];
            private int length = 0;
            private int[] lineStartOffsets = EMPTY;

            Builder() {
            }

            public LineIndex build() {
                int[] lines = new int[this.length];
                System.arraycopy(this.lineStartOffsets, 0, lines, 0, this.length);
                this.lineStartOffsets = EMPTY;
                return new LineIndex(lines);
            }

            public Builder lineStartOffset(int offset) {
                if (this.length >= this.lineStartOffsets.length) {
                    int[] newArr = new int[this.lineStartOffsets.length + 16];
                    System.arraycopy(this.lineStartOffsets, 0, newArr, 0, this.lineStartOffsets.length);
                    this.lineStartOffsets = newArr;
                }
                this.lineStartOffsets[this.length++] = offset;
                return this;
            }
        }
    }
}

