/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.lint.api;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ec4j.lint.api.Edit;
import org.ec4j.lint.api.FormatException;
import org.ec4j.lint.api.Location;
import org.ec4j.lint.api.Logger;
import org.ec4j.lint.api.Resource;
import org.ec4j.lint.api.Violation;
import org.ec4j.lint.api.ViolationHandler;

public class FormattingHandler
implements ViolationHandler {
    private final boolean backup;
    private final String backupSuffix;
    private Resource currentFile;
    private int editedFileCount = 0;
    private final Logger log;
    private int processedFileCount = 0;
    private List<Violation> violations = new ArrayList<Violation>();

    public FormattingHandler(boolean backup, String backupSuffix, Logger log) {
        this.backup = backup;
        this.backupSuffix = backupSuffix;
        this.log = log;
    }

    private void backupAndStoreIfNeeded() throws IOException {
        if (this.currentFile.changed()) {
            if (this.backup) {
                Path originalFile = this.currentFile.getPath();
                Path backupFile = Paths.get(originalFile.toString() + this.backupSuffix, new String[0]);
                Files.move(originalFile, backupFile, new CopyOption[0]);
            }
            this.currentFile.store();
        }
    }

    @Override
    public ViolationHandler.ReturnState endFile() {
        try {
            Object object;
            if (this.violations.isEmpty()) {
                this.log.debug("No formatting violations found in file '{}' ", this.currentFile);
                this.backupAndStoreIfNeeded();
                ViolationHandler.ReturnState returnState = ViolationHandler.ReturnState.FINISHED;
                return returnState;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Fixing {} formatting {}  in file '{}'", this.violations.size(), this.violations.size() == 1 ? "violation" : "violations", this.currentFile);
            }
            ++this.editedFileCount;
            HashSet<Integer> linesEdited = new HashSet<Integer>();
            boolean recheckNeeded = false;
            for (Violation violation : this.violations) {
                Location loc = violation.getLocation();
                Integer line = loc.getLine();
                if (!linesEdited.contains(line)) {
                    int lineStartOffset = this.currentFile.findLineStart(loc.getLine());
                    int editOffset = lineStartOffset + loc.getColumn() - 1;
                    Edit fix = violation.getFix();
                    this.log.debug("About to perform '{}' at {}, lineStartOffset {}, editOffset {}", fix.getMessage(), loc, lineStartOffset, editOffset);
                    fix.perform(this.currentFile, editOffset);
                    linesEdited.add(line);
                    continue;
                }
                recheckNeeded = true;
            }
            if (recheckNeeded) {
                object = ViolationHandler.ReturnState.RECHECK;
                return object;
            }
            this.backupAndStoreIfNeeded();
            object = ViolationHandler.ReturnState.FINISHED;
            return object;
        }
        catch (IOException e) {
            throw new FormatException("Could not format file " + this.currentFile, e);
        }
        finally {
            ++this.processedFileCount;
            this.currentFile = null;
            this.violations.clear();
        }
    }

    @Override
    public void endFiles() {
        this.log.info("Formatted {} out of {} {}", this.editedFileCount, this.processedFileCount, this.editedFileCount == 1 ? "file" : "files");
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    @Override
    public void handle(Violation violation) {
        this.log.info(violation.toString(), new Object[0]);
        this.violations.add(violation);
    }

    public boolean hasViolations() {
        return !this.violations.isEmpty();
    }

    @Override
    public void startFile(Resource file) {
        this.currentFile = file;
    }

    @Override
    public void startFiles() {
        this.processedFileCount = 0;
    }
}

