/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.ant;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.fest.swing.junit.xml.XmlAttribute;
import org.fest.swing.junit.xml.XmlAttributes;
import org.fest.swing.junit.xml.XmlNode;

class SuiteXmlNodeWriter {
    SuiteXmlNodeWriter() {
    }

    SuiteXmlNodeWriter writeSuiteName(XmlNode target, JUnitTest suite) {
        String suiteName = suite.getName();
        target.addAttribute(XmlAttribute.name("name").value(suiteName == null ? "unknown" : suiteName));
        return this;
    }

    SuiteXmlNodeWriter writeSuiteProperties(XmlNode target, JUnitTest suite) {
        XmlNode propertiesNode = target.addNewNode("properties");
        Properties properties = suite.getProperties();
        if (properties == null) {
            return this;
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            this.writeProperty(propertiesNode, properties, (String)propertyNames.nextElement());
        }
        return this;
    }

    private void writeProperty(XmlNode target, Properties properties, String propertyName) {
        String propertyValue = properties.getProperty(propertyName);
        target.addNewNode("property", XmlAttributes.attributes(XmlAttribute.name("name").value(propertyName), XmlAttribute.name("value").value(propertyValue)));
    }

    SuiteXmlNodeWriter writeSuiteStatistics(XmlNode target, JUnitTest suite) {
        target.addAttribute(XmlAttribute.name("tests").value(suite.runCount()));
        target.addAttribute(XmlAttribute.name("failures").value(suite.failureCount()));
        target.addAttribute(XmlAttribute.name("errors").value(suite.errorCount()));
        target.addAttribute(XmlAttribute.name("time").value((double)suite.getRunTime() / 1000.0));
        return this;
    }
}

