/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.manager.statistics;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import org.easypeelsecurity.springdog.manager.statistics.SystemUsageMetrics;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;

public class SystemUsageMonitor
implements SystemUsageMetrics {
    private final SystemInfo systemInfo = new SystemInfo();
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private final HardwareAbstractionLayer hardware = this.systemInfo.getHardware();

    @Override
    public Double getSystemMemoryUsagePercent() {
        GlobalMemory memory = this.hardware.getMemory();
        long totalMemory = memory.getTotal();
        long availableMemory = memory.getAvailable();
        double usedMemoryPercent = (double)(totalMemory - availableMemory) / (double)totalMemory * 100.0;
        return this.formatDouble(usedMemoryPercent);
    }

    @Override
    public Double systemCpuUsagePercent() {
        CentralProcessor processor = this.hardware.getProcessor();
        double[] loadAverage = processor.getSystemLoadAverage(1);
        return this.formatDouble(loadAverage[0]);
    }

    @Override
    public Double diskUsagePercent() {
        FileSystem fileSystem = this.systemInfo.getOperatingSystem().getFileSystem();
        List fileStores = fileSystem.getFileStores();
        long totalSpace = 0L;
        long usedSpace = 0L;
        for (OSFileStore store : fileStores) {
            totalSpace += store.getTotalSpace();
            usedSpace += store.getTotalSpace() - store.getUsableSpace();
        }
        if (totalSpace == 0L) {
            return null;
        }
        return this.formatDouble((double)usedSpace / (double)totalSpace * 100.0);
    }

    @Override
    public long getJvmHeapUsed() {
        return this.memoryMXBean.getHeapMemoryUsage().getUsed();
    }

    @Override
    public long getJvmHeapMax() {
        return this.memoryMXBean.getHeapMemoryUsage().getMax();
    }

    @Override
    public Double getJvmHeapUsagePercent() {
        MemoryUsage heapMemoryUsage = this.memoryMXBean.getHeapMemoryUsage();
        return this.formatDouble((double)heapMemoryUsage.getUsed() / (double)heapMemoryUsage.getMax() * 100.0);
    }

    @Override
    public long getJvmNonHeapUsed() {
        return this.memoryMXBean.getNonHeapMemoryUsage().getUsed();
    }

    @Override
    public long getJvmNonHeapMax() {
        return this.memoryMXBean.getNonHeapMemoryUsage().getMax();
    }

    @Override
    public Double getJvmNonHeapUsagePercent() {
        MemoryUsage nonHeapMemoryUsage = this.memoryMXBean.getNonHeapMemoryUsage();
        long max = nonHeapMemoryUsage.getMax();
        if (max < 0L) {
            return -1.0;
        }
        return this.formatDouble((double)nonHeapMemoryUsage.getUsed() / (double)max * 100.0);
    }

    @Override
    public long getJvmTotalMemoryUsed() {
        return this.getJvmHeapUsed() + this.getJvmNonHeapUsed();
    }

    @Override
    public long getJvmTotalMemoryMax() {
        return this.getJvmHeapMax() + this.getJvmNonHeapMax();
    }

    @Override
    public Double getJvmTotalMemoryUsagePercent() {
        long totalUsed = this.getJvmTotalMemoryUsed();
        long totalMax = this.getJvmTotalMemoryMax();
        if (totalMax <= 0L) {
            return -1.0;
        }
        return this.formatDouble((double)totalUsed / (double)totalMax * 100.0);
    }

    @Override
    public long getNetworkInBytes() {
        return this.hardware.getNetworkIFs().stream().mapToLong(NetworkIF::getBytesRecv).sum();
    }

    @Override
    public long getNetworkOutBytes() {
        return this.hardware.getNetworkIFs().stream().mapToLong(NetworkIF::getBytesSent).sum();
    }
}

