/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.manager.statistics;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.easypeelsecurity.springdog.manager.statistics.EndpointMetricCacheManager;
import org.easypeelsecurity.springdog.manager.util.RequestHandlerUtil;
import org.easypeelsecurity.springdog.notification.SlowResponseEmailNotificationManager;
import org.easypeelsecurity.springdog.shared.util.MethodSignatureParser;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class RequestTimingInterceptor
implements HandlerInterceptor {
    private static final String SKIP_REQUEST_TIMING_CALC = "SKIP_REQUEST_TIMING_CALC";
    private static final String START_TIME_REQUEST_TIMING = "START_TIME_REQUEST_TIMING";
    private final SlowResponseEmailNotificationManager notificationManager;

    public RequestTimingInterceptor(SlowResponseEmailNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        HandlerMethod handlerMethod;
        Object controller;
        Class<?> controllerClass;
        request.setAttribute(SKIP_REQUEST_TIMING_CALC, (Object)true);
        request.setAttribute(START_TIME_REQUEST_TIMING, (Object)System.currentTimeMillis());
        if (handler instanceof HandlerMethod && !RequestHandlerUtil.shouldSkipRequest(controllerClass = (controller = (handlerMethod = (HandlerMethod)handler).getBean()).getClass())) {
            request.setAttribute(SKIP_REQUEST_TIMING_CALC, (Object)false);
            return true;
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        boolean shouldSkip = (Boolean)request.getAttribute(SKIP_REQUEST_TIMING_CALC);
        if (shouldSkip) {
            return;
        }
        long startTime = (Long)request.getAttribute(START_TIME_REQUEST_TIMING);
        long endTime = System.currentTimeMillis();
        long responseTime = endTime - startTime;
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        String methodSignature = MethodSignatureParser.parse((HandlerMethod)handlerMethod);
        EndpointMetricCacheManager.addResponseTime(methodSignature, responseTime);
        this.notificationManager.checkSlowResponse(new SlowResponseEmailNotificationManager.SlowResponse(request.getRequestURI(), request.getMethod(), responseTime));
    }
}

