/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.manager.ratelimit;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.LocalDateTime;
import org.easypeelsecurity.springdog.shared.dto.EndpointDto;

public final class RatelimitCache {
    private RatelimitCache() {
    }

    private static LocalDateTime[] addTimestamp(String requestHashed, LocalDateTime nowTime) {
        LocalDateTime[] after;
        LocalDateTime[] before = (LocalDateTime[])RatelimitCache.getAccessHistoryInstance().getIfPresent((Object)requestHashed);
        if (before != null) {
            after = new LocalDateTime[before.length + 1];
            System.arraycopy(before, 0, after, 0, before.length);
            after[before.length] = nowTime;
        } else {
            after = new LocalDateTime[]{nowTime};
        }
        RatelimitCache.getAccessHistoryInstance().put((Object)requestHashed, (Object)after);
        return after;
    }

    public static void ban(String requestHashed, LocalDateTime banUntil) {
        RatelimitCache.getAccessHistoryInstance().invalidate((Object)requestHashed);
        RatelimitCache.getBanHistoryInstance().put((Object)requestHashed, (Object)banUntil);
    }

    public static void clearCaches() {
        RatelimitCache.getAccessHistoryInstance().invalidateAll();
        RatelimitCache.getBanHistoryInstance().invalidateAll();
    }

    public static synchronized boolean isBannedRequest(String requestHashed, EndpointDto endpoint, LocalDateTime nowTime) {
        if (RatelimitCache.checkAlreadyBanned(requestHashed, nowTime)) {
            return true;
        }
        LocalDateTime[] timestamps = RatelimitCache.addTimestamp(requestHashed, nowTime);
        int count = 0;
        int timeFrameSeconds = endpoint.getRuleTimeLimitInSeconds();
        for (LocalDateTime timestamp : timestamps) {
            if (!timestamp.isAfter(nowTime.minusSeconds(timeFrameSeconds))) continue;
            ++count;
        }
        if (count > endpoint.getRuleRequestLimitCount()) {
            int banTimeSeconds = endpoint.isRulePermanentBan() ? Integer.MAX_VALUE : endpoint.getRuleBanTimeInSeconds();
            RatelimitCache.ban(requestHashed, nowTime.plusSeconds(banTimeSeconds));
            return true;
        }
        return false;
    }

    private static boolean checkAlreadyBanned(String requestHashed, LocalDateTime nowTime) {
        LocalDateTime banExpireDateTime = (LocalDateTime)RatelimitCache.getBanHistoryInstance().getIfPresent((Object)requestHashed);
        if (banExpireDateTime != null) {
            if (banExpireDateTime.isBefore(nowTime)) {
                RatelimitCache.getBanHistoryInstance().invalidate((Object)requestHashed);
                return false;
            }
            return true;
        }
        return false;
    }

    private static Cache<String, LocalDateTime[]> getAccessHistoryInstance() {
        return AccessHistoryHolder.INSTANCE;
    }

    private static Cache<String, LocalDateTime> getBanHistoryInstance() {
        return BanHistoryHolder.INSTANCE;
    }

    private static final class AccessHistoryHolder {
        private static final Cache<String, LocalDateTime[]> INSTANCE = Caffeine.newBuilder().build();

        private AccessHistoryHolder() {
        }
    }

    private static final class BanHistoryHolder {
        private static final Cache<String, LocalDateTime> INSTANCE = Caffeine.newBuilder().build();

        private BanHistoryHolder() {
        }
    }
}

