/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.manager.errortracing;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionListingService;
import org.easypeelsecurity.springdog.shared.dto.ExceptionClassesDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class StructuredExceptionLister {
    private static final Logger logger = LoggerFactory.getLogger(StructuredExceptionLister.class);
    private final ApplicationContext applicationContext;
    private final Environment environment;
    private final ExceptionListingService exceptionListingService;
    private static final Map<String, String> JAVA_EXCEPTION_PACKAGES = new LinkedHashMap<String, String>();

    public StructuredExceptionLister(ApplicationContext applicationContext, Environment environment, ExceptionListingService exceptionListingService) {
        this.applicationContext = applicationContext;
        this.environment = environment;
        this.exceptionListingService = exceptionListingService;
    }

    @PostConstruct
    public void listExceptions() {
        ExceptionClassesDto list = this.scanExistExceptionClasses();
        this.exceptionListingService.saveExceptionsWithoutDuplicate(list);
    }

    private ExceptionClassesDto scanExistExceptionClasses() {
        String basePackage = this.findBasePackage();
        LinkedHashMap<String, List<String>> exceptionsByPackage = new LinkedHashMap<String, List<String>>();
        try (ScanResult scanResult = new ClassGraph().enableSystemJarsAndModules().acceptPackages(this.getAcceptPackages(basePackage)).scan();){
            List<String> exceptionClasses = scanResult.getSubclasses(Exception.class.getName()).getNames().stream().filter(this::isLoadableClass).toList();
            for (String className : exceptionClasses) {
                String packageType = this.getPackageType(className, basePackage);
                exceptionsByPackage.computeIfAbsent(packageType, k -> new ArrayList()).add(className);
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while scanning for exception classes", (Throwable)e);
        }
        return this.createExceptionClassesDto(exceptionsByPackage);
    }

    private ExceptionClassesDto createExceptionClassesDto(Map<String, List<String>> exceptionsByPackage) {
        ArrayList<ExceptionClassesDto.ExceptionListDto> exceptionLists = new ArrayList<ExceptionClassesDto.ExceptionListDto>();
        for (Map.Entry<String, List<String>> entry : exceptionsByPackage.entrySet()) {
            String packageType = entry.getKey();
            List<String> exceptions = entry.getValue();
            List<ExceptionClassesDto.ExceptionListDto.ExceptionItemDto> exceptionItems = exceptions.stream().map(exceptionName -> ExceptionClassesDto.ExceptionListDto.ExceptionItemDto.builder().exceptionName(exceptionName).isEnableToMonitor(true).build()).toList();
            ExceptionClassesDto.ExceptionListDto exceptionList = ExceptionClassesDto.ExceptionListDto.builder().packageType(packageType).description(JAVA_EXCEPTION_PACKAGES.getOrDefault(packageType, "Application specific exceptions")).subExceptions(exceptionItems).build();
            exceptionLists.add(exceptionList);
        }
        return new ExceptionClassesDto(exceptionLists);
    }

    private String[] getAcceptPackages(String basePackage) {
        ArrayList<String> packages = new ArrayList<String>(JAVA_EXCEPTION_PACKAGES.keySet());
        packages.add(basePackage);
        return packages.toArray(new String[0]);
    }

    private String getPackageType(String className, String basePackage) {
        return JAVA_EXCEPTION_PACKAGES.keySet().stream().filter(className::startsWith).findFirst().orElse(basePackage);
    }

    private String findBasePackage() {
        String[] beanNames = this.applicationContext.getBeanNamesForAnnotation(SpringBootApplication.class);
        if (beanNames.length > 0) {
            Class<?> mainClass = this.applicationContext.getBean(beanNames[0]).getClass();
            return mainClass.getPackage().getName();
        }
        String sources = this.environment.getProperty("spring.main.sources");
        if (sources != null && !sources.isEmpty()) {
            return sources.split(",")[0].trim().replaceAll("\\.[^.]*$", "");
        }
        logger.warn("Unable to determine base package. Using empty string.");
        return "";
    }

    private boolean isLoadableClass(String className) {
        try {
            Class.forName(className, false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            logger.warn("Unable to load class: {}. Reason: {}", (Object)className, (Object)e.getMessage());
            return false;
        }
    }

    static {
        JAVA_EXCEPTION_PACKAGES.put("java.lang", "Core Java classes including basic exceptions");
        JAVA_EXCEPTION_PACKAGES.put("java.io", "Input/Output related exceptions");
        JAVA_EXCEPTION_PACKAGES.put("java.nio", "New I/O related exceptions");
        JAVA_EXCEPTION_PACKAGES.put("java.net", "Networking related exceptions");
        JAVA_EXCEPTION_PACKAGES.put("java.util", "Utility class related exceptions");
        JAVA_EXCEPTION_PACKAGES.put("java.sql", "SQL and database related exceptions");
        JAVA_EXCEPTION_PACKAGES.put("java.security", "Security related exceptions");
        JAVA_EXCEPTION_PACKAGES.put("java.time", "Date and time handling related exceptions");
        JAVA_EXCEPTION_PACKAGES.put("javax.crypto", "Cryptography related exceptions");
    }
}

