/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.manager.errortracing;

import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionListingService;
import org.easypeelsecurity.springdog.shared.dto.ErrorTracingDto;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class SpringdogExceptionCollector {
    private final ExceptionListingService exceptionListingService;

    public SpringdogExceptionCollector(ExceptionListingService exceptionListingService) {
        this.exceptionListingService = exceptionListingService;
    }

    @ExceptionHandler(value={Exception.class})
    public void collectException(Exception e) {
        String exceptionClassName = e.getClass().getName();
        if (!this.exceptionListingService.isExceptionEnabled(exceptionClassName)) {
            return;
        }
        ErrorTracingDto errorChain = this.buildErrorChain(e);
        this.exceptionListingService.saveException(errorChain);
    }

    private ErrorTracingDto buildErrorChain(Throwable throwable) {
        ErrorTracingDto currentDto = null;
        ErrorTracingDto rootDto = null;
        while (throwable != null) {
            StackTraceElement element;
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            StackTraceElement stackTraceElement = element = stackTrace.length > 0 ? stackTrace[0] : null;
            if (element == null) break;
            ErrorTracingDto newDto = ErrorTracingDto.builder().message(throwable.getMessage()).fileName(element.getFileName()).className(element.getClassName()).methodName(element.getMethodName()).lineNumber(element.getLineNumber()).build();
            if (currentDto == null) {
                rootDto = newDto;
            } else {
                currentDto.setNext(newDto);
            }
            currentDto = newDto;
            throwable = throwable.getCause();
        }
        return rootDto;
    }
}

