/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.manager.agent;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.easypeelsecurity.springdog.shared.configuration.SpringdogProperties;
import org.easypeelsecurity.springdog.shared.util.IpAddressUtil;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.HandlerInterceptor;

@Service
public class AgentExternalAccessInterceptor
implements HandlerInterceptor {
    private final SpringdogProperties properties;

    public AgentExternalAccessInterceptor(SpringdogProperties properties) {
        this.properties = properties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (!this.isAgentRequest(request)) {
            return true;
        }
        if (this.properties.enableExternalAccess()) {
            return true;
        }
        String ipAddress = IpAddressUtil.getClientIp((HttpServletRequest)request);
        if (!IpAddressUtil.isLocal((String)ipAddress)) {
            response.setStatus(403);
            return false;
        }
        return true;
    }

    private boolean isAgentRequest(HttpServletRequest request) {
        return request.getRequestURI().startsWith(this.properties.computeAbsolutePath(""));
    }
}

