/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.domain.statistics;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.query.ObjectSelect;
import org.easypeelsecurity.springdog.domain.ratelimit.EndpointRepository;
import org.easypeelsecurity.springdog.domain.ratelimit.model.Endpoint;
import org.easypeelsecurity.springdog.domain.statistics.EndpointMetricRepository;
import org.easypeelsecurity.springdog.domain.statistics.SystemMetricRepository;
import org.easypeelsecurity.springdog.domain.statistics.converter.SystemMetricConverter;
import org.easypeelsecurity.springdog.domain.statistics.model.EndpointMetric;
import org.easypeelsecurity.springdog.domain.statistics.model.SystemMetric;
import org.easypeelsecurity.springdog.shared.dto.EndpointMetricDto;
import org.easypeelsecurity.springdog.shared.dto.SystemMetricDto;
import org.easypeelsecurity.springdog.shared.enums.RuleStatus;
import org.easypeelsecurity.springdog.shared.util.Assert;
import org.easypeelsecurity.springdog.shared.vo.DashboardResponse;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class StatisticsService {
    private final ObjectContext context;
    private final EndpointRepository endpointRepository;
    private final EndpointMetricRepository endpointMetricRepository;
    private final SystemMetricRepository systemMetricRepository;

    public StatisticsService(@Qualifier(value="springdogContext") ObjectContext context, EndpointRepository endpointRepository, EndpointMetricRepository endpointMetricRepository, SystemMetricRepository systemMetricRepository) {
        this.context = context;
        this.endpointRepository = endpointRepository;
        this.endpointMetricRepository = endpointMetricRepository;
        this.systemMetricRepository = systemMetricRepository;
    }

    public DashboardResponse getDashboardResponse(LocalDate specificDate) {
        long totalEndpointCount = this.endpointRepository.getEndpointCount(this.context);
        long totalActiveEndpointCount = this.endpointRepository.getEndpointCountByStatus(this.context, RuleStatus.ACTIVE.name());
        List<SystemMetricDto> recentSystemMetrics = this.systemMetricRepository.getRecentSystemMetrics(this.context, 30).stream().map(SystemMetricConverter::convert).toList();
        return new DashboardResponse(totalEndpointCount, totalActiveEndpointCount, totalEndpointCount - totalActiveEndpointCount, recentSystemMetrics, this.endpointMetricRepository.getDailyEndpointMetrics(this.context, 10), this.endpointMetricRepository.getDailyTopTrafficEndpoints(this.context, 7, specificDate), this.endpointMetricRepository.getDailySlowestEndpoints(this.context, 7, specificDate), this.endpointMetricRepository.getDailyTopFailWithRatelimitEndpoints(this.context, 7, specificDate));
    }

    public void upsertEndpointMetrics(String methodSignature, long[] responseTimes, long failureCount, LocalDate today) {
        Assert.isTrue((boolean)Arrays.stream(responseTimes).allMatch(time -> time >= 0L), (String)"Response times must be non-negative");
        Assert.isTrue((today != null ? 1 : 0) != 0, (String)"Date must not be null");
        Assert.isTrue((failureCount >= 0L ? 1 : 0) != 0, (String)"Failure count must be non-negative");
        Endpoint endpoint = (Endpoint)((Object)ObjectSelect.query(Endpoint.class).where(Endpoint.METHOD_SIGNATURE.eq((Object)methodSignature)).selectOne(this.context));
        Assert.notNull((Object)((Object)endpoint), (String)"Endpoint not found");
        EndpointMetric endpointMetric = this.endpointMetricRepository.findByEndpointAndMetricDateOrNull(this.context, endpoint, today);
        if (endpointMetric == null) {
            endpointMetric = (EndpointMetric)((Object)this.context.newObject(EndpointMetric.class));
            endpointMetric.setEndpoint(endpoint);
            endpointMetric.setMetricDate(today);
        }
        long responseTimeSum = Arrays.stream(responseTimes).sum();
        endpointMetric.updateStatistics(responseTimes.length, responseTimeSum, failureCount);
        this.context.commitChanges();
    }

    public void storeSystemMetrics(double cpuUsagePercent, double memoryUsagePercent, double diskUsagePercent, double jvmHeapUsagePercent, double jvmNonHeapUsagePercent, long jvmTotalMemoryUsed, long networkInBytes, long networkOutBytes) {
        if (cpuUsagePercent < 0.0 || cpuUsagePercent > 100.0) {
            throw new IllegalArgumentException("CPU usage percentage must be between 0 and 100");
        }
        if (memoryUsagePercent < 0.0 || memoryUsagePercent > 100.0) {
            throw new IllegalArgumentException("Memory usage percentage must be between 0 and 100");
        }
        if (diskUsagePercent < 0.0 || diskUsagePercent > 100.0) {
            throw new IllegalArgumentException("Disk usage percentage must be between 0 and 100");
        }
        SystemMetric systemMetric = (SystemMetric)((Object)this.context.newObject(SystemMetric.class));
        systemMetric.setCpuUsagePercent(cpuUsagePercent);
        systemMetric.setMemoryUsagePercent(memoryUsagePercent);
        systemMetric.setDiskUsagePercent(diskUsagePercent);
        systemMetric.setJvmHeapUsagePercent(jvmHeapUsagePercent);
        systemMetric.setJvmNonHeapUsagePercent(jvmNonHeapUsagePercent);
        systemMetric.setJvmTotalMemoryUsed(jvmTotalMemoryUsed);
        systemMetric.setNetworkInBytes(networkInBytes);
        systemMetric.setNetworkOutBytes(networkOutBytes);
        this.context.commitChanges();
    }

    public List<EndpointMetricDto> getRecentEndpointMetric(long endpointId, int limitDays) {
        return this.endpointMetricRepository.getRecentEndpointMetrics(this.context, endpointId, limitDays).stream().map(metric -> new EndpointMetricDto(metric.getEndpoint().getPath(), metric.getEndpoint().getHttpMethod(), metric.getPageView(), metric.getAverageResponseMs(), metric.getFailureWithRatelimit(), metric.getMetricDate())).toList();
    }

    public List<SystemMetricDto> getRecentSystemMetrics(int limit) {
        return this.systemMetricRepository.getRecentSystemMetrics(this.context, limit).stream().map(SystemMetricConverter::convert).toList();
    }

    public void changeMemo(Long metricId, String description) {
        SystemMetric systemMetric = (SystemMetric)((Object)ObjectSelect.query(SystemMetric.class).where(SystemMetric.ID.eq((Object)metricId)).selectOne(this.context));
        Assert.notNull((Object)((Object)systemMetric), (String)"System metric not found");
        if (StringUtils.hasText((String)description)) {
            systemMetric.setMemo(description);
        } else {
            systemMetric.setMemo(null);
        }
        this.context.commitChanges();
    }
}

