/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.domain.ratelimit;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Optional;
import org.easypeelsecurity.springdog.shared.dto.EndpointDto;

public final class RuleCache {
    private RuleCache() {
    }

    public static Optional<EndpointDto> findEndpointByMethodSignature(String methodSignature) {
        EndpointDto temp = (EndpointDto)RuleCache.getInstance().getIfPresent((Object)methodSignature);
        return temp == null ? Optional.empty() : Optional.of(temp);
    }

    public static void cachingRule(EndpointDto endpointDto) {
        RuleCache.getInstance().put((Object)endpointDto.getMethodSignature(), (Object)endpointDto);
    }

    public static void changeRuleCached(String methodSignature, EndpointDto endpointDto) {
        RuleCache.getInstance().put((Object)methodSignature, (Object)endpointDto);
    }

    private static Cache<String, EndpointDto> getInstance() {
        return RuleCacheHolder.INSTANCE;
    }

    private static final class RuleCacheHolder {
        private static final Cache<String, EndpointDto> INSTANCE = Caffeine.newBuilder().build();

        private RuleCacheHolder() {
        }
    }
}

