/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.domain.errortracing.model.converter;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cayenne.ObjectContext;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionCause;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionClass;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionType;
import org.easypeelsecurity.springdog.shared.dto.ErrorTracingDto;
import org.easypeelsecurity.springdog.shared.dto.ExceptionClassesDto;

public abstract class ExceptionConverter {
    public static List<Object> convertDtoToEntities(ObjectContext context, ExceptionClassesDto dto) {
        ArrayList<Object> entities = new ArrayList<Object>();
        for (ExceptionClassesDto.ExceptionListDto exceptionList : dto.exceptionList()) {
            ExceptionType exceptionType = (ExceptionType)((Object)context.newObject(ExceptionType.class));
            exceptionType.setPackageType(exceptionList.packageType());
            exceptionType.setDescription(exceptionList.description());
            entities.add((Object)exceptionType);
            for (ExceptionClassesDto.ExceptionListDto.ExceptionItemDto item : exceptionList.subExceptions()) {
                ExceptionClass exceptionClass = (ExceptionClass)((Object)context.newObject(ExceptionClass.class));
                exceptionClass.setExceptionClassName(item.exceptionName());
                exceptionClass.setRootExceptionPackageType(exceptionType);
                exceptionClass.setMonitoringEnabled(item.isEnableToMonitor());
                entities.add((Object)exceptionClass);
            }
        }
        return entities;
    }

    public static ErrorTracingDto entityToErrorTracingDto(ExceptionCause exceptionCause) {
        if (exceptionCause == null) {
            return null;
        }
        ErrorTracingDto result = ErrorTracingDto.builder().id(Long.valueOf(exceptionCause.getId())).message(exceptionCause.getMessage()).fileName(exceptionCause.getFileName()).className(exceptionCause.getClassName()).methodName(exceptionCause.getMethodName()).lineNumber(exceptionCause.getLine()).timestamp(exceptionCause.getTimestamp()).build();
        if (exceptionCause.getNextException() != null) {
            ErrorTracingDto next = ExceptionConverter.entityToErrorTracingDto(exceptionCause.getNextException());
            next.setParentTraceId(result.getId());
            result.setNext(next);
        }
        return result;
    }

    public static List<ErrorTracingDto> entityToErrorTracingDto(List<ExceptionCause> exceptionCauses) {
        if (exceptionCauses == null || exceptionCauses.isEmpty()) {
            return new ArrayList<ErrorTracingDto>();
        }
        ArrayList<ErrorTracingDto> result = new ArrayList<ErrorTracingDto>();
        for (ExceptionCause exceptionCause : exceptionCauses) {
            result.add(ExceptionConverter.entityToErrorTracingDto(exceptionCause));
        }
        return result;
    }

    public static ExceptionClassesDto convertEntitiesToDto(List<ExceptionType> exceptionTypes) {
        List<ExceptionClassesDto.ExceptionListDto> exceptionLists = exceptionTypes.stream().map(type -> {
            List subExceptions = type.getExceptionClasses().stream().map(subException -> ExceptionClassesDto.ExceptionListDto.ExceptionItemDto.builder().exceptionId(Long.valueOf(subException.getId())).exceptionName(subException.getExceptionClassName()).isEnableToMonitor(subException.isMonitoringEnabled()).build()).collect(Collectors.toList());
            return ExceptionClassesDto.ExceptionListDto.builder().packageTypeId(Long.valueOf(type.getId())).packageType(type.getPackageType()).description(type.getDescription()).subExceptions(subExceptions).build();
        }).toList();
        return new ExceptionClassesDto(exceptionLists);
    }

    public static ExceptionClass convertDtoToEntity(ObjectContext context, ExceptionType existType, ExceptionClassesDto.ExceptionListDto.ExceptionItemDto newExceptionClass) {
        ExceptionClass exceptionClass = (ExceptionClass)((Object)context.newObject(ExceptionClass.class));
        exceptionClass.setExceptionClassName(newExceptionClass.exceptionName());
        exceptionClass.setRootExceptionPackageType(existType);
        existType.addToExceptionClasses(exceptionClass);
        exceptionClass.setMonitoringEnabled(newExceptionClass.isEnableToMonitor());
        return exceptionClass;
    }

    public static ExceptionCause convertDtoToEntity(ObjectContext context, ErrorTracingDto errorChain) {
        if (errorChain == null) {
            return null;
        }
        ExceptionCause rootCause = (ExceptionCause)((Object)context.newObject(ExceptionCause.class));
        return ExceptionConverter.convertRecursive(context, errorChain, rootCause);
    }

    private static ExceptionCause convertRecursive(ObjectContext context, ErrorTracingDto errorChain, ExceptionCause currentCause) {
        if (errorChain == null) {
            return null;
        }
        currentCause.setMessage(errorChain.getMessage());
        currentCause.setFileName(errorChain.getFileName());
        currentCause.setClassName(errorChain.getClassName());
        currentCause.setMethodName(errorChain.getMethodName());
        currentCause.setLine(errorChain.getLineNumber());
        currentCause.setTimestamp(LocalDateTime.now());
        if (errorChain.getNext() != null) {
            ExceptionCause nextCause = (ExceptionCause)((Object)context.newObject(ExceptionCause.class));
            nextCause.setParentExceptionId(currentCause.getId());
            currentCause.setNextException(nextCause);
            ExceptionConverter.convertRecursive(context, errorChain.getNext(), nextCause);
        }
        return currentCause;
    }
}

