/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.autoconfigure.controller.parser;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.easypeelsecurity.springdog.autoconfigure.controller.parser.ParameterNameExtractor;
import org.easypeelsecurity.springdog.domain.ratelimit.VersionControlService;
import org.easypeelsecurity.springdog.shared.configuration.SpringdogProperties;
import org.easypeelsecurity.springdog.shared.dto.EndpointDto;
import org.easypeelsecurity.springdog.shared.dto.EndpointHeaderDto;
import org.easypeelsecurity.springdog.shared.dto.EndpointParameterDto;
import org.easypeelsecurity.springdog.shared.enums.EndpointParameterType;
import org.easypeelsecurity.springdog.shared.util.Assert;
import org.easypeelsecurity.springdog.shared.util.MethodSignatureParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component(value="springdogControllerParserComponent")
public class ControllerParser {
    private final Logger logger = LoggerFactory.getLogger(ControllerParser.class);
    private final RequestMappingHandlerMapping handlerMapping;
    private final VersionControlService versionControlService;
    private final SpringdogProperties properties;

    public ControllerParser(@Qualifier(value="requestMappingHandlerMapping") RequestMappingHandlerMapping handlerMapping, VersionControlService versionControlService, SpringdogProperties properties) {
        this.handlerMapping = handlerMapping;
        this.versionControlService = versionControlService;
        this.properties = properties;
    }

    private EndpointDto getEndpointDto(HandlerMethod method, String endPoint, org.easypeelsecurity.springdog.shared.enums.HttpMethod httpMethod, boolean isPatternPath) {
        String methodSignature = MethodSignatureParser.parse((HandlerMethod)method);
        EndpointDto endpoint = EndpointDto.builder().methodSignature(methodSignature).path(endPoint).httpMethod(httpMethod).isPatternPath(isPatternPath).build();
        Set<EndpointParameterDto> parameters = this.parseRequestParameters(method);
        Set<EndpointHeaderDto> headers = this.parseRequestHeaders(method);
        endpoint.addParameters(parameters);
        endpoint.addHeaders(headers);
        return endpoint;
    }

    private Set<EndpointHeaderDto> parseRequestHeaders(HandlerMethod method) {
        Parameter[] parameters;
        HashSet<EndpointHeaderDto> headers = new HashSet<EndpointHeaderDto>();
        for (Parameter parameter : parameters = method.getMethod().getParameters()) {
            RequestHeader requestHeaderAnnotation = parameter.getAnnotation(RequestHeader.class);
            if (requestHeaderAnnotation == null) continue;
            String headerName = requestHeaderAnnotation.value();
            if (headerName.isEmpty()) {
                headerName = parameter.getName();
            }
            headers.add(new EndpointHeaderDto(headerName, false));
        }
        return headers;
    }

    private Set<EndpointParameterDto> parseRequestParameters(HandlerMethod method) {
        HashSet<EndpointParameterDto> parameters = new HashSet<EndpointParameterDto>();
        try {
            String[] paramNames = ParameterNameExtractor.getParameterNames(method.getBeanType(), method.getMethod().getName(), method.getMethod().getParameterTypes());
            Parameter[] methodParameters = method.getMethod().getParameters();
            for (int i = 0; i < methodParameters.length; ++i) {
                if (methodParameters[i].getAnnotation(RequestHeader.class) != null) continue;
                String name = paramNames != null && i < paramNames.length ? paramNames[i] : methodParameters[i].getName();
                parameters.add(new EndpointParameterDto(name, EndpointParameterType.resolve((Annotation[])methodParameters[i].getAnnotations()), false));
            }
        }
        catch (IOException | NoSuchMethodException e) {
            this.logger.error("Error while extracting parameter names.", (Throwable)e);
        }
        return parameters;
    }

    @PostConstruct
    public void listEndpointsAndParameters() {
        Assert.notNull((Object)this.handlerMapping, (String)"RequestMappingHandlerMapping is required.");
        Assert.notNull((Object)this.properties, (String)"SpringdogProperties is required.");
        List<EndpointDto> parsedEndpointFromController = this.parseController(this.handlerMapping.getHandlerMethods(), this.properties.computeAbsolutePath("/"));
        this.versionControlService.updateVersion(parsedEndpointFromController);
    }

    List<EndpointDto> parseController(Map<RequestMappingInfo, HandlerMethod> handlerMethods, String excludePathPrefix) {
        ArrayList<EndpointDto> result = new ArrayList<EndpointDto>();
        for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : handlerMethods.entrySet()) {
            org.easypeelsecurity.springdog.shared.enums.HttpMethod httpMethod;
            HandlerMethod method;
            RequestMappingInfo info = entry.getKey();
            String endpoint = this.extractEndpointPath(info, method = entry.getValue());
            if (endpoint == null || endpoint.startsWith(excludePathPrefix) || (httpMethod = this.extractHttpMethod(info)) == null) continue;
            boolean isPatternPath = info.getDirectPaths().isEmpty();
            result.add(this.getEndpointDto(method, endpoint, httpMethod, isPatternPath));
        }
        return result;
    }

    private String extractEndpointPath(RequestMappingInfo info, HandlerMethod method) {
        if (!info.getDirectPaths().isEmpty()) {
            if (info.getDirectPaths().size() > 1) {
                this.logger.warn("Multiple paths found for {} in {} (directPath). but not supported yet.", (Object)method.getMethod().getName(), (Object)method.getBeanType());
                return null;
            }
            return (String)info.getDirectPaths().iterator().next();
        }
        if (!info.getPatternValues().isEmpty()) {
            if (info.getPatternValues().size() > 1) {
                this.logger.warn("Multiple paths found for {} in {} (patternUrl). but not supported yet.", (Object)method.getMethod().getName(), (Object)method.getBeanType());
                return null;
            }
            return (String)info.getPatternValues().iterator().next();
        }
        return null;
    }

    private org.easypeelsecurity.springdog.shared.enums.HttpMethod extractHttpMethod(RequestMappingInfo info) {
        Set methods = info.getMethodsCondition().getMethods();
        if (!methods.isEmpty()) {
            return org.easypeelsecurity.springdog.shared.enums.HttpMethod.resolve((HttpMethod)((RequestMethod)methods.iterator().next()).asHttpMethod());
        }
        return null;
    }
}

