/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.autoconfigure.applier;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.Generated;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import org.easypeelsecurity.springdog.autoconfigure.applier.SpringDogEnable;
import org.easypeelsecurity.springdog.shared.util.Assert;

public abstract class CodeGenerator {
    static final String ANNOTATION_DEFAULT_FIELD = "value";

    public TypeSpec.Builder typeSpec() {
        throw new UnsupportedOperationException("typeSpec() not implemented");
    }

    public final void writeTo(String packageName, ProcessingEnvironment processingEnv) {
        Assert.hasText((String)packageName, (String)"Package name must not be empty");
        Assert.notNull((Object)processingEnv, (String)"ProcessingEnvironment must not be null");
        Assert.isTrue((boolean)this.getClass().getSimpleName().equals(this.typeSpec().build().name), (String)"TypeSpec name must match class name. Expected %s, but was %s", (Object[])new Object[]{this.getClass().getSimpleName(), this.typeSpec().build().name});
        try {
            JavaFile.builder((String)packageName, (TypeSpec)this.generate()).build().writeTo(processingEnv.getFiler());
        }
        catch (IOException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error writing " + String.valueOf(this.typeSpec()) + " to file: " + e.getMessage());
        }
    }

    private TypeSpec generate() {
        for (AnnotationSpec annotation : this.typeSpec().build().annotations) {
            if (!annotation.type.toString().equals(Generated.class.getName())) continue;
            throw new IllegalStateException("TypeSpec already contains a Generated annotation.");
        }
        return this.typeSpec().addAnnotation(AnnotationSpec.builder(Generated.class).addMember(ANNOTATION_DEFAULT_FIELD, "$S", new Object[]{SpringDogEnable.class.getName()}).build()).build();
    }
}

