/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.agent;

import java.util.Collections;
import org.easypeelsecurity.springdog.agent.SpringdogAgentController;
import org.easypeelsecurity.springdog.shared.configuration.SpringdogProperties;
import org.easypeelsecurity.springdog.shared.util.Assert;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerTypePredicate;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class SpringdogDynamicUrlMappingConfig
implements WebMvcRegistrations {
    private final SpringdogProperties springdogProperties;

    public SpringdogDynamicUrlMappingConfig(SpringdogProperties springdogProperties) {
        this.springdogProperties = springdogProperties;
    }

    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return new CustomRequestMappingHandlerMapping(this.springdogProperties);
    }

    static class CustomRequestMappingHandlerMapping
    extends RequestMappingHandlerMapping {
        private final SpringdogProperties springdogProperties;

        CustomRequestMappingHandlerMapping(SpringdogProperties springdogProperties) {
            this.springdogProperties = springdogProperties;
        }

        protected void initHandlerMethods() {
            String basePath = this.springdogProperties.computeAbsolutePath("");
            Assert.notNull((Object)basePath, (String)"Springdog Agent's base path must not be null");
            this.setPathPrefixes(Collections.singletonMap(basePath, HandlerTypePredicate.forAnnotation((Class[])new Class[]{SpringdogAgentController.class})));
            super.initHandlerMethods();
        }
    }
}

