/*
 * Decompiled with CFR 0.152.
 */
package org.easypeelsecurity.springdog.agent;

import org.easypeelsecurity.springdog.agent.CommonResponse;
import org.easypeelsecurity.springdog.agent.SpringdogAPIExceptionHandler;
import org.easypeelsecurity.springdog.agent.SpringdogAgentController;
import org.easypeelsecurity.springdog.domain.errortracing.model.ExceptionListingService;
import org.easypeelsecurity.springdog.domain.statistics.StatisticsService;
import org.easypeelsecurity.springdog.shared.dto.ErrorTracingDto;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@SpringdogAgentController
public class SpringdogAPI
extends SpringdogAPIExceptionHandler {
    private final ExceptionListingService exceptionListingService;
    private final StatisticsService statisticsService;

    public SpringdogAPI(ExceptionListingService exceptionListingService, StatisticsService statisticsService) {
        this.exceptionListingService = exceptionListingService;
        this.statisticsService = statisticsService;
    }

    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @GetMapping(value={"/error-tracing/configuration/{exceptionClassId}"})
    public void errorExceptionMonitoringStatus(@PathVariable(name="exceptionClassId") long exceptionClassId, @RequestParam(value="enabled") boolean enabled) {
        this.exceptionListingService.changeMonitoringStatus(exceptionClassId, enabled);
    }

    @GetMapping(value={"/error-tracing/{errorTracingId}"})
    public CommonResponse<ErrorTracingDto> getErrorTracing(@PathVariable(name="errorTracingId") long errorTracingId) {
        return new CommonResponse<ErrorTracingDto>(this.exceptionListingService.getErrorTrace(errorTracingId));
    }

    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PostMapping(value={"/system-watch/{metricId}/memo"})
    public void addMemo(@PathVariable(value="metricId") Long metricId, @RequestParam(value="description") String description) {
        this.statisticsService.changeMemo(metricId, description);
    }
}

