/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.extensions.apache.common.csv;

import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.easybatch.core.mapper.AbstractRecordMapper;
import org.easybatch.core.mapper.RecordMapper;
import org.easybatch.core.record.GenericRecord;
import org.easybatch.core.record.Record;
import org.easybatch.core.record.StringRecord;

public class ApacheCommonCsvRecordMapper<P>
extends AbstractRecordMapper<P>
implements RecordMapper<StringRecord, Record<P>> {
    private CSVFormat csvFormat = CSVFormat.newFormat((char)',');

    public ApacheCommonCsvRecordMapper(Class<P> recordClass, String ... columns) {
        super(recordClass);
        this.csvFormat = this.csvFormat.withHeader(columns);
    }

    public Record<P> processRecord(StringRecord record) throws Exception {
        String payload = (String)record.getPayload();
        CSVParser csvParser = this.csvFormat.parse((Reader)new StringReader(payload));
        CSVRecord csvRecord = (CSVRecord)csvParser.iterator().next();
        csvParser.close();
        return new GenericRecord(record.getHeader(), this.objectMapper.mapObject(csvRecord.toMap()));
    }

    public void setTrim(boolean trim) {
        this.csvFormat = this.csvFormat.withTrim(trim);
    }

    public void setDelimiter(char delimiter) {
        this.csvFormat = this.csvFormat.withDelimiter(delimiter);
    }

    public void setQuote(char quote) {
        this.csvFormat = this.csvFormat.withQuote(quote);
    }
}

