/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.extensions.apache.common.csv;

import java.beans.IntrospectionException;
import java.io.StringWriter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.easybatch.core.field.BeanRecordFieldExtractor;
import org.easybatch.core.field.RecordFieldExtractor;
import org.easybatch.core.marshaller.RecordMarshaller;
import org.easybatch.core.marshaller.RecordMarshallingException;
import org.easybatch.core.record.GenericRecord;
import org.easybatch.core.record.StringRecord;

public class ApacheCommonCsvRecordMarshaller
implements RecordMarshaller<GenericRecord, StringRecord> {
    public static final char DEFAULT_DELIMITER = ',';
    public static final char DEFAULT_QUALIFIER = '\"';
    private final RecordFieldExtractor fieldExtractor;
    private CSVFormat csvFormat;

    public ApacheCommonCsvRecordMarshaller(Class type, String ... fields) throws IntrospectionException {
        this(type, fields, ',', '\"');
    }

    public ApacheCommonCsvRecordMarshaller(Class type, String[] fields, char delimiter) throws IntrospectionException {
        this(type, fields, delimiter, '\"');
    }

    public ApacheCommonCsvRecordMarshaller(Class type, String[] fields, char delimiter, char qualifier) throws IntrospectionException {
        this((RecordFieldExtractor)new BeanRecordFieldExtractor(type, fields), delimiter, qualifier);
    }

    public ApacheCommonCsvRecordMarshaller(RecordFieldExtractor fieldExtractor, char delimiter, char qualifier) throws IntrospectionException {
        this.fieldExtractor = fieldExtractor;
        this.csvFormat = CSVFormat.newFormat((char)delimiter).withQuote(qualifier).withQuoteMode(QuoteMode.ALL).withRecordSeparator(null);
    }

    public StringRecord processRecord(GenericRecord record) throws RecordMarshallingException {
        try {
            StringWriter stringWriter = new StringWriter();
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, this.csvFormat);
            Iterable iterable = this.fieldExtractor.extractFields(record.getPayload());
            csvPrinter.printRecord(iterable);
            csvPrinter.flush();
            return new StringRecord(record.getHeader(), stringWriter.toString());
        }
        catch (Exception e) {
            throw new RecordMarshallingException((Throwable)e);
        }
    }
}

