/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.integration.apache.common.csv;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.easybatch.core.api.Header;
import org.easybatch.core.api.RecordReader;
import org.easybatch.core.api.RecordReaderClosingException;
import org.easybatch.core.util.Utils;
import org.easybatch.integration.apache.common.csv.ApacheCommonCsvRecord;

public class ApacheCommonCsvRecordReader
implements RecordReader {
    private CSVParser parser;
    private Iterator<CSVRecord> iterator;

    public ApacheCommonCsvRecordReader(CSVParser parser) {
        Utils.checkNotNull((Object)parser, (String)"csv parser");
        this.parser = parser;
    }

    public void open() {
        this.iterator = this.parser.iterator();
    }

    public boolean hasNextRecord() {
        return this.iterator.hasNext();
    }

    public ApacheCommonCsvRecord readNextRecord() {
        Header header = new Header(Long.valueOf(this.parser.getRecordNumber()), this.getDataSourceName(), new Date());
        return new ApacheCommonCsvRecord(header, this.iterator.next());
    }

    public Long getTotalRecords() {
        return null;
    }

    public String getDataSourceName() {
        return this.parser.toString();
    }

    public void close() throws RecordReaderClosingException {
        try {
            this.parser.close();
        }
        catch (IOException e) {
            throw new RecordReaderClosingException("Unable to close record reader", (Throwable)e);
        }
    }
}

