/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.runner;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.annotation.DataLoader;
import org.easetech.easytest.loader.DataConverter;
import org.easetech.easytest.loader.Loader;
import org.easetech.easytest.loader.LoaderFactory;
import org.easetech.easytest.loader.LoaderType;
import org.easetech.easytest.runner.EasyFrameworkMethod;
import org.easetech.easytest.util.DataContext;
import org.easetech.easytest.util.RunAftersWithOutputData;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.theories.DataPoint;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.experimental.theories.internal.Assignments;
import org.junit.experimental.theories.internal.ParameterizedAssertionError;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Runner;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDrivenTest
extends Suite {
    private String[] dataFiles;
    private Loader dataLoader = null;
    private static Map<String, List<Map<String, Object>>> writableData = new HashMap<String, List<Map<String, Object>>>();
    private static int rowNum = 0;
    private String mapMethodName = "";
    protected static final Logger PARAM_LOG = LoggerFactory.getLogger(DataDrivenTest.class);
    private final ArrayList<Runner> runners = new ArrayList();
    private String superMethodName;
    private List<FrameworkMethod> unusedFrameworkMethods;

    protected List<Runner> getChildren() {
        return this.runners;
    }

    public DataDrivenTest(Class<?> klass) throws InitializationError {
        super(klass, Collections.emptyList());
        Class testClass = this.getTestClass().getJavaClass();
        this.loadData(klass, null, testClass);
        List availableMethods = this.getTestClass().getAnnotatedMethods(Test.class);
        ArrayList<FrameworkMethod> methodsWithNoData = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod method : availableMethods) {
            this.superMethodName = DataConverter.getFullyQualifiedTestName(method.getName(), testClass);
            if (method.getAnnotation(DataLoader.class) != null) {
                this.runners.add((Runner)new EasyTestRunner(this.getTestClass().getJavaClass()));
                continue;
            }
            boolean methodDataLoaded = this.isMethodDataLoaded(DataConverter.getFullyQualifiedTestName(method.getName(), testClass));
            if (methodDataLoaded) {
                this.runners.add((Runner)new EasyTestRunner(this.getTestClass().getJavaClass()));
                continue;
            }
            methodsWithNoData.add(method);
        }
        if (!methodsWithNoData.isEmpty()) {
            this.unusedFrameworkMethods = methodsWithNoData;
            this.runners.add((Runner)new GivenTestMethodsRunner(klass));
        }
        this.superMethodName = null;
    }

    protected boolean isMethodDataLoaded(String methodName) {
        boolean result = false;
        if (DataContext.getData() == null || DataContext.getData().keySet() == null || DataContext.getData().keySet().isEmpty()) {
            result = false;
        } else {
            Iterator<String> keyIterator = DataContext.getData().keySet().iterator();
            while (keyIterator.hasNext() && !(result = methodName.equals(keyIterator.next()))) {
            }
        }
        return result;
    }

    protected void loadData(Class<?> testClass, FrameworkMethod method, Class<?> currentTestClass) {
        if (testClass == null && method == null) {
            Assert.fail((String)"The framework should provide either the testClass parameter or the method parameter in order to load the test data.");
        }
        DataLoader testData = null;
        testData = testClass != null ? testClass.getAnnotation(DataLoader.class) : (DataLoader)method.getAnnotation(DataLoader.class);
        if (testData != null) {
            this.determineLoader(testData);
            if (this.dataLoader == null) {
                Assert.fail((String)"The framework currently does not support the specified Loader type. You can provide the custom Loader by choosing LoaderType.CUSTOM in TestData annotation and providing your custom loader using DataLoader annotation.");
            } else {
                Map<String, List<Map<String, Object>>> data = this.dataLoader.loadData(this.dataFiles);
                writableData.putAll(data);
                DataContext.setData(DataConverter.appendClassName(data, currentTestClass));
                DataContext.setConvertedData(DataConverter.convert(data, currentTestClass));
            }
        }
    }

    private void determineLoader(DataLoader testData) {
        this.dataFiles = testData.filePaths();
        LoaderType loaderType = testData.loaderType();
        this.dataLoader = null;
        if (LoaderType.CUSTOM.equals((Object)loaderType)) {
            PARAM_LOG.info("User specified to use custom Loader. Trying to get the custom loader.");
            if (testData.loader() == null) {
                Assert.fail((String)"Specified the LoaderType as CUSTOM but did not specify loader attribute. A loaderType of CUSTOM requires the loader attribute specifying the Custom Loader Class which implements Loader interface.");
            } else {
                try {
                    Class<? extends Loader> loaderClass = testData.loader();
                    this.dataLoader = loaderClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception occured while trying to instantiate a class of type :" + testData.loader(), e);
                }
            }
        } else if (this.dataFiles.length == 0) {
            if (testData.loader() == null) {
                Assert.fail((String)"Specified the LoaderType as CUSTOM but did not specify loader attribute. A loaderType of CUSTOM requires the loader attribute specifying the Custom Loader Class which implements Loader interface.");
            } else {
                try {
                    Class<? extends Loader> loaderClass = testData.loader();
                    this.dataLoader = loaderClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception occured while trying to instantiate a class of type :" + testData.loader(), e);
                }
            }
        } else {
            this.dataLoader = LoaderFactory.getLoader(loaderType);
        }
    }

    static /* synthetic */ String[] access$302(DataDrivenTest x0, String[] x1) {
        x0.dataFiles = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GivenTestMethodsRunner
    extends BlockJUnit4ClassRunner {
        private final List<FrameworkMethod> methodsToRun;

        public GivenTestMethodsRunner(Class<?> klass) throws InitializationError {
            super(klass);
            this.methodsToRun = DataDrivenTest.this.unusedFrameworkMethods;
        }

        public List<FrameworkMethod> getMethodsToRun() {
            return this.methodsToRun;
        }

        protected void validateTestMethods(List<Throwable> errors) {
        }

        protected List<FrameworkMethod> computeTestMethods() {
            ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>();
            List methodsAvailable = super.computeTestMethods();
            block0: for (FrameworkMethod method : DataDrivenTest.this.unusedFrameworkMethods) {
                for (FrameworkMethod fMethod : methodsAvailable) {
                    if (!fMethod.getName().equals(method.getName())) continue;
                    result.add(fMethod);
                    continue block0;
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EasyTestRunner
    extends BlockJUnit4ClassRunner {
        private final String methodName;
        List<FrameworkMethod> frameworkMethods;

        public String getMethodName() {
            return this.methodName;
        }

        public EasyTestRunner(Class<?> klass) throws InitializationError {
            super(klass);
            this.methodName = DataDrivenTest.this.superMethodName;
        }

        protected void collectInitializationErrors(List<Throwable> errors) {
            super.collectInitializationErrors(errors);
            this.validateDataPointFields(errors);
        }

        protected String testName(FrameworkMethod method) {
            return String.format("%s", method.getName());
        }

        protected List<FrameworkMethod> computeTestMethods() {
            if (this.frameworkMethods != null && !this.frameworkMethods.isEmpty()) {
                return this.frameworkMethods;
            }
            if (DataDrivenTest.this.superMethodName == null) {
                Assert.fail((String)"Cannot compute Test Methods to run");
            }
            ArrayList<FrameworkMethod> finalList = new ArrayList<FrameworkMethod>();
            Iterator testMethodsItr = super.computeTestMethods().iterator();
            Class testClass = this.getTestClass().getJavaClass();
            while (testMethodsItr.hasNext()) {
                FrameworkMethod method = (FrameworkMethod)testMethodsItr.next();
                if (!DataDrivenTest.this.superMethodName.equals(DataConverter.getFullyQualifiedTestName(method.getName(), testClass))) continue;
                DataDrivenTest.this.loadData(null, method, this.getTestClass().getJavaClass());
                List<Map<String, Object>> methodData = DataContext.getData().get(DataDrivenTest.this.superMethodName);
                if (methodData == null) {
                    Assert.fail((String)("Method with name : " + DataDrivenTest.this.superMethodName + " expects some input test data. But there doesnt seem to be any test " + "data for the given method. Please check the Test Data file for the method data. " + "Possible cause could be a spelling mismatch."));
                }
                for (Map<String, Object> testData : methodData) {
                    EasyFrameworkMethod easyMethod = new EasyFrameworkMethod(method.getMethod());
                    easyMethod.setName(method.getName().concat(testData.toString()));
                    finalList.add(easyMethod);
                }
            }
            if (finalList.isEmpty()) {
                Assert.fail((String)("No method exists with the given name :" + DataDrivenTest.this.superMethodName));
            }
            this.frameworkMethods = finalList;
            return finalList;
        }

        private void validateDataPointFields(List<Throwable> errors) {
            Field[] fields;
            for (Field each : fields = this.getTestClass().getJavaClass().getDeclaredFields()) {
                if (each.getAnnotation(DataPoint.class) == null || Modifier.isStatic(each.getModifiers())) continue;
                errors.add(new Error("DataPoint field " + each.getName() + " must be static"));
            }
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected void validateTestMethods(List<Throwable> errors) {
        }

        public Statement methodBlock(FrameworkMethod method) {
            return new ParamAnchor(method, this.getTestClass());
        }

        protected Statement withAfterClasses(Statement statement) {
            List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
            FrameworkMethod method = this.frameworkMethods.get(0);
            if (method.getMethod().getReturnType() != Void.TYPE) {
                DataLoader loaderAnnotation = (DataLoader)method.getAnnotation(DataLoader.class);
                if (loaderAnnotation != null) {
                    DataDrivenTest.this.determineLoader(loaderAnnotation);
                } else {
                    loaderAnnotation = this.getTestClass().getJavaClass().getAnnotation(DataLoader.class);
                    if (loaderAnnotation != null) {
                        DataDrivenTest.this.determineLoader(loaderAnnotation);
                    }
                }
                if (DataDrivenTest.this.dataLoader == null) {
                    Assert.fail((String)"The framework currently does not support the specified Loader type. You can provide the custom Loader by choosing LoaderType.CUSTOM in TestData annotation and providing your custom loader using DataLoader annotation.");
                }
                DataDrivenTest.access$302(DataDrivenTest.this, loaderAnnotation.filePaths());
            } else {
                DataDrivenTest.this.dataLoader = null;
            }
            return new RunAftersWithOutputData(statement, afters, null, DataDrivenTest.this.dataLoader, DataDrivenTest.this.dataFiles, writableData);
        }

        public class ParamAnchor
        extends Statement {
            protected final Logger LOG = LoggerFactory.getLogger(ParamAnchor.class);
            private int successes = 0;
            private FrameworkMethod fTestMethod;
            private TestClass fTestClass;
            private List<Assignments> listOfAssignments;
            private List<AssumptionViolatedException> fInvalidParameters = new ArrayList<AssumptionViolatedException>();

            public ParamAnchor(FrameworkMethod method, TestClass testClass) {
                this.fTestMethod = method;
                this.fTestClass = testClass;
                this.listOfAssignments = new ArrayList<Assignments>();
                DataContext.setMethodName(DataConverter.getFullyQualifiedTestName(method.getName(), testClass.getJavaClass()));
            }

            private TestClass getTestClass() {
                return this.fTestClass;
            }

            public void evaluate() throws Throwable {
                this.runWithAssignment(Assignments.allUnassigned((Method)this.fTestMethod.getMethod(), (TestClass)this.getTestClass()));
                this.LOG.debug("ParamAnchor evaluate");
                if (this.successes == 0) {
                    Assert.fail((String)("Never found parameters that satisfied method assumptions.  Violated assumptions: " + this.fInvalidParameters));
                }
            }

            protected void runWithAssignment(Assignments parameterAssignment) throws Throwable {
                while (!parameterAssignment.isComplete()) {
                    List potentialAssignments = parameterAssignment.potentialsForNextUnassigned();
                    boolean isFirstSetOfArguments = this.listOfAssignments.isEmpty();
                    for (int i = 0; i < potentialAssignments.size(); ++i) {
                        Assignments assignments;
                        if (isFirstSetOfArguments) {
                            assignments = Assignments.allUnassigned((Method)this.fTestMethod.getMethod(), (TestClass)this.getTestClass());
                            this.listOfAssignments.add(assignments.assignNext((PotentialAssignment)potentialAssignments.get(i)));
                            continue;
                        }
                        assignments = this.listOfAssignments.get(i);
                        try {
                            this.listOfAssignments.set(i, assignments.assignNext((PotentialAssignment)potentialAssignments.get(i)));
                            continue;
                        }
                        catch (IndexOutOfBoundsException e) {
                            this.listOfAssignments.add(assignments.assignNext((PotentialAssignment)potentialAssignments.get(i)));
                        }
                    }
                    parameterAssignment = parameterAssignment.assignNext(null);
                }
                if (this.listOfAssignments.isEmpty()) {
                    this.LOG.debug("The list of Assignments is null. It normally happens when the user has not supplied any parameters to the test.");
                    this.LOG.debug(" Creating an instance of Assignments object with all its value unassigned.");
                    this.listOfAssignments.add(Assignments.allUnassigned((Method)this.fTestMethod.getMethod(), (TestClass)this.getTestClass()));
                }
                for (Assignments assignments : this.listOfAssignments) {
                    this.runWithCompleteAssignment(assignments);
                }
            }

            protected void runWithCompleteAssignment(final Assignments complete) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, Throwable {
                new BlockJUnit4ClassRunner(this.getTestClass().getJavaClass()){

                    protected void collectInitializationErrors(List<Throwable> errors) {
                    }

                    public Statement methodBlock(FrameworkMethod method) {
                        final Statement statement = super.methodBlock(method);
                        return new Statement(){

                            public void evaluate() throws Throwable {
                                try {
                                    statement.evaluate();
                                    ParamAnchor.this.handleDataPointSuccess();
                                }
                                catch (AssumptionViolatedException e) {
                                    ParamAnchor.this.handleAssumptionViolation(e);
                                }
                                catch (Throwable e) {
                                    ParamAnchor.this.reportParameterizedError(e, complete.getArgumentStrings(true));
                                }
                            }
                        };
                    }

                    protected Statement methodInvoker(FrameworkMethod method, Object test) {
                        return ParamAnchor.this.methodCompletesWithParameters(method, complete, test);
                    }

                    public Object createTest() throws Exception {
                        return this.getTestClass().getOnlyConstructor().newInstance(complete.getConstructorArguments(true));
                    }
                }.methodBlock(this.fTestMethod).evaluate();
            }

            private Statement methodCompletesWithParameters(final FrameworkMethod method, final Assignments complete, final Object freshInstance) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        try {
                            Object[] values = complete.getMethodArguments(true);
                            Object returnObj = method.invokeExplosively(freshInstance, values);
                            if (returnObj != null) {
                                ParamAnchor.this.LOG.debug("returnObj:" + returnObj);
                                if (!DataDrivenTest.this.mapMethodName.equals(method.getMethod().getName())) {
                                    DataDrivenTest.this.mapMethodName = method.getMethod().getName();
                                    rowNum = 0;
                                }
                                ParamAnchor.this.LOG.debug("mapMethodName:" + DataDrivenTest.this.mapMethodName + " ,rowNum:" + rowNum);
                                if (writableData.get(DataDrivenTest.this.mapMethodName) != null) {
                                    ParamAnchor.this.LOG.debug("writableData.get(mapMethodName)" + writableData.get(DataDrivenTest.this.mapMethodName) + " ,rowNum:" + rowNum);
                                    Map writableRow = (Map)((List)writableData.get(DataDrivenTest.this.mapMethodName)).get(rowNum);
                                    writableRow.put("ActualResult", returnObj);
                                    Object expectedResult = writableRow.get("ExpectedResult");
                                    if (expectedResult != null) {
                                        ParamAnchor.this.LOG.debug("Expected result exists");
                                        if (expectedResult.toString().equals(returnObj.toString())) {
                                            writableRow.put("TestStatus", "PASSED");
                                        } else {
                                            writableRow.put("TestStatus", "FAILED");
                                        }
                                    }
                                    rowNum++;
                                }
                            }
                        }
                        catch (PotentialAssignment.CouldNotGenerateValueException couldNotGenerateValueException) {
                            // empty catch block
                        }
                    }
                };
            }

            protected void handleAssumptionViolation(AssumptionViolatedException e) {
                this.fInvalidParameters.add(e);
            }

            protected void reportParameterizedError(Throwable e, Object ... params) throws Throwable {
                if (params.length == 0) {
                    throw e;
                }
                throw new ParameterizedAssertionError(e, this.fTestMethod.getName(), params);
            }

            protected void handleDataPointSuccess() {
                ++this.successes;
            }
        }
    }
}

