/*
 * Decompiled with CFR 0.152.
 */
package org.easetech.easytest.loader;

import com.csvreader.CsvReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easetech.easytest.loader.Loader;
import org.easetech.easytest.util.ResourceLoader;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVDataLoader
implements Loader {
    protected static final Logger LOG = LoggerFactory.getLogger(CSVDataLoader.class);
    private static final char COMMA_SEPARATOR = ',';

    public CSVDataLoader() {
    }

    public CSVDataLoader(List<InputStream> csvInputStreams) throws IOException {
        Map<String, List<Map<String, Object>>> data = null;
        HashMap<String, List<Map<String, Object>>> finalData = new HashMap<String, List<Map<String, Object>>>();
        for (InputStream stream : csvInputStreams) {
            data = CSVDataLoader.loadFromSpreadsheet(stream);
            finalData.putAll(data);
        }
    }

    private Map<String, List<Map<String, Object>>> loadCSVData(List<String> dataFiles) throws IOException {
        Map<String, List<Map<String, Object>>> data = null;
        HashMap<String, List<Map<String, Object>>> finalData = new HashMap<String, List<Map<String, Object>>>();
        for (String filePath : dataFiles) {
            try {
                ResourceLoader resource = new ResourceLoader(filePath);
                data = CSVDataLoader.loadFromSpreadsheet(resource.getInputStream());
            }
            catch (FileNotFoundException e) {
                LOG.error("The specified file was not found. The path is : {}", (Object)filePath);
                LOG.error("Continuing with the loading of next file.");
                continue;
            }
            catch (IOException e) {
                LOG.error("IO Exception occured while trying to read the data from the file : {}", (Object)filePath);
                LOG.error("Continuing with the loading of next file.");
                continue;
            }
            finalData.putAll(data);
        }
        return finalData;
    }

    private static Map<String, List<Map<String, Object>>> loadFromSpreadsheet(InputStream csvFile) throws IOException {
        HashMap<String, List<Map<String, Object>>> data = new HashMap<String, List<Map<String, Object>>>();
        CsvReader csvReader = new CsvReader((Reader)new InputStreamReader(csvFile), ',');
        Boolean isKeyRow = true;
        ArrayList dataValues = null;
        HashMap<Integer, String> tempData = new HashMap<Integer, String>();
        data = new HashMap();
        while (csvReader.readRecord()) {
            int i;
            HashMap actualData = new HashMap();
            String[] splitValues = csvReader.getValues();
            isKeyRow = splitValues.length > 0 && "".equals(splitValues[0]) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            if (isKeyRow.booleanValue()) {
                dataValues = new ArrayList();
                for (i = 0; i < splitValues.length; ++i) {
                    tempData.put(i, splitValues[i]);
                }
                data.put((String)tempData.get(0), dataValues);
            } else {
                for (i = 1; i < splitValues.length; ++i) {
                    actualData.put(tempData.get(i), splitValues[i]);
                }
            }
            if (isKeyRow.booleanValue()) continue;
            dataValues.add(actualData);
        }
        return data;
    }

    @Override
    public Map<String, List<Map<String, Object>>> loadData(String[] filePaths) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap();
        try {
            result = this.loadCSVData(Arrays.asList(filePaths));
        }
        catch (IOException e) {
            Assert.fail((String)("An I/O exception occured while reading the files from the path :" + filePaths.toString()));
        }
        return result;
    }

    @Override
    public void writeData(String filePath, Map<String, List<Map<String, Object>>> actualData) {
    }
}

