/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client;

import org.duracloud.error.ContentStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StoreCaller<T> {
    private final Logger log = LoggerFactory.getLogger(StoreCaller.class);

    public T call() {
        T result = null;
        boolean callComplete = false;
        int maxTries = 3;
        int tries = 0;
        while (!callComplete && tries < maxTries) {
            try {
                result = this.doCall();
                callComplete = true;
            }
            catch (ContentStoreException e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.log.warn(this.getLogMessage());
                ++tries;
            }
        }
        return result;
    }

    protected abstract T doCall() throws ContentStoreException;

    public abstract String getLogMessage();
}

