/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.xml.impl;

import java.util.HashMap;
import java.util.Map;
import org.duracloud.common.model.Credential;
import org.duracloud.common.util.EncryptionUtil;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.domain.impl.StorageAccountImpl;
import org.duracloud.storage.xml.StorageAccountProviderBinding;
import org.jdom.Content;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageAccountProviderSimpleBindingImpl
implements StorageAccountProviderBinding {
    private final Logger log = LoggerFactory.getLogger(StorageAccountProviderSimpleBindingImpl.class);
    private EncryptionUtil encryptionUtil = new EncryptionUtil();

    @Override
    public StorageAccount getAccountFromXml(Element xml) {
        StorageProviderType acctType = this.getStorageProviderType(xml);
        String storageAccountId = this.getAccountId(xml);
        boolean primary = this.getIsPrimary(xml);
        Credential credential = this.getCredential(xml);
        Map<String, String> options = this.getStorageProviderOptions(xml);
        StorageAccountImpl storageAccount = null;
        if (storageAccountId != null && acctType != null && !acctType.equals((Object)StorageProviderType.UNKNOWN)) {
            storageAccount = new StorageAccountImpl(storageAccountId, credential.getUsername(), credential.getPassword(), acctType);
            for (String key : options.keySet()) {
                storageAccount.setOption(key, options.get(key));
            }
            storageAccount.setPrimary(primary);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("While creating storage account list, skipping simple ");
            sb.append("storage account with storageAccountId '");
            sb.append(storageAccountId);
            sb.append("' due to either a missing storageAccountId, ");
            sb.append("an unsupported type '");
            sb.append(acctType);
            sb.append("', or a missing username or password");
            this.log.warn(sb.toString());
        }
        return storageAccount;
    }

    protected StorageProviderType getStorageProviderType(Element xml) {
        String type = xml.getChildText("storageProviderType");
        return StorageProviderType.fromString((String)type);
    }

    protected String getAccountId(Element xml) {
        return xml.getChildText("id");
    }

    protected boolean getIsPrimary(Element xml) {
        String primary = xml.getAttributeValue("isPrimary");
        if (null == primary) {
            return false;
        }
        return primary.equals("1") || primary.equalsIgnoreCase("true");
    }

    protected Credential getCredential(Element xml) {
        String username = null;
        String password = null;
        Element credentials = xml.getChild("storageProviderCredential");
        if (null != credentials) {
            String encUsername = credentials.getChildText("username");
            String encPassword = credentials.getChildText("password");
            if (null != encUsername && null != encPassword) {
                username = this.encryptionUtil.decrypt(encUsername);
                password = this.encryptionUtil.decrypt(encPassword);
            }
        }
        return new Credential(username, password);
    }

    private Map<String, String> getStorageProviderOptions(Element xml) {
        HashMap<String, String> options = new HashMap<String, String>();
        Element optionsXml = xml.getChild("storageProviderOptions");
        if (null != optionsXml) {
            for (Element optionXml : optionsXml.getChildren("option")) {
                String name = optionXml.getAttributeValue("name");
                String value = optionXml.getAttributeValue("value");
                options.put(name, value);
            }
        }
        return options;
    }

    @Override
    public Element getElementFrom(StorageAccount acct, boolean includeCredentials, boolean includeHiddenOptions) {
        Map<String, String> options;
        Element storageAcct = new Element("storageAcct");
        storageAcct.setAttribute("ownerId", "0");
        String isPrimary = acct.isPrimary() ? "1" : "0";
        storageAcct.setAttribute("isPrimary", isPrimary);
        Element id = new Element("id");
        id.addContent(acct.getId());
        storageAcct.addContent((Content)id);
        Element storageProviderType = new Element("storageProviderType");
        storageProviderType.addContent(acct.getType().name());
        storageAcct.addContent((Content)storageProviderType);
        if (includeCredentials) {
            Element storageProviderCredential = new Element("storageProviderCredential");
            String uname = this.encryptionUtil.encrypt(acct.getUsername());
            String pword = this.encryptionUtil.encrypt(acct.getPassword());
            Element username = new Element("username");
            Element password = new Element("password");
            username.addContent(uname);
            password.addContent(pword);
            storageProviderCredential.addContent((Content)username);
            storageProviderCredential.addContent((Content)password);
            storageAcct.addContent((Content)storageProviderCredential);
        }
        if (null != (options = acct.getOptions()) && !options.isEmpty()) {
            Element storageProviderOptions = new Element("storageProviderOptions");
            storageAcct.addContent((Content)storageProviderOptions);
            for (String key : options.keySet()) {
                if (!includeHiddenOptions && StorageAccount.OPTS.valueOf(key).isHidden()) continue;
                Element option = new Element("option");
                option.setAttribute("name", key);
                option.setAttribute("value", options.get(key));
                storageProviderOptions.addContent((Content)option);
            }
        }
        return storageAcct;
    }
}

