/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.model;

import java.util.HashSet;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public enum Role {
    ROLE_INIT("Init"),
    ROLE_ROOT("Root"),
    ROLE_OWNER("Owner"),
    ROLE_ADMIN("Administrator"),
    ROLE_USER("User"),
    ROLE_ANONYMOUS("Anonymous");

    private GrantedAuthority authority = new SimpleGrantedAuthority(this.name());
    private String displayName;

    private Role(String displayName) {
        this.displayName = displayName;
    }

    public GrantedAuthority authority() {
        return this.authority;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Set<Role> getRoleHierarchy() {
        HashSet<Role> hierarchy = new HashSet<Role>();
        switch (this) {
            case ROLE_ROOT: {
                hierarchy.add(ROLE_ROOT);
            }
            case ROLE_OWNER: {
                hierarchy.add(ROLE_OWNER);
            }
            case ROLE_ADMIN: {
                hierarchy.add(ROLE_ADMIN);
            }
            case ROLE_USER: {
                hierarchy.add(ROLE_USER);
            }
            case ROLE_ANONYMOUS: {
                hierarchy.add(ROLE_ANONYMOUS);
                break;
            }
            case ROLE_INIT: {
                hierarchy.add(ROLE_INIT);
                break;
            }
        }
        return hierarchy;
    }

    public static Role highestRole(Set<Role> roles) {
        Role highest = null;
        if (roles.contains((Object)ROLE_ROOT)) {
            return ROLE_ROOT;
        }
        if (roles.contains((Object)ROLE_OWNER)) {
            return ROLE_OWNER;
        }
        if (roles.contains((Object)ROLE_ADMIN)) {
            return ROLE_ADMIN;
        }
        if (roles.contains((Object)ROLE_USER)) {
            return ROLE_USER;
        }
        if (roles.contains((Object)ROLE_ANONYMOUS)) {
            return ROLE_ANONYMOUS;
        }
        return highest;
    }
}

