/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.duckdb.DuckDBColumnType;
import org.duckdb.DuckDBConnection;
import org.duckdb.DuckDBNative;
import org.duckdb.DuckDBPreparedStatement;
import org.duckdb.DuckDBResultSetMetaData;
import org.duckdb.DuckDBVector;
import org.duckdb.JdbcUtils;
import org.duckdb.JsonNode;

public class DuckDBResultSet
implements ResultSet {
    private final DuckDBConnection conn;
    private final DuckDBPreparedStatement stmt;
    private final DuckDBResultSetMetaData meta;
    private ByteBuffer resultRef;
    private final Lock resultRefLock = new ReentrantLock();
    private DuckDBVector[] currentChunk = new DuckDBVector[0];
    private int chunkIdx = 0;
    private boolean finished = false;
    private boolean wasNull;

    public DuckDBResultSet(DuckDBConnection conn, DuckDBPreparedStatement stmt, DuckDBResultSetMetaData meta, ByteBuffer resultRef) throws SQLException {
        try {
            this.conn = Objects.requireNonNull(conn);
            this.stmt = Objects.requireNonNull(stmt);
            this.resultRef = Objects.requireNonNull(resultRef);
            this.meta = Objects.requireNonNull(meta);
        }
        catch (NullPointerException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkOpen();
        return this.stmt;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this.meta;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkOpen();
        if (this.finished) {
            return false;
        }
        ++this.chunkIdx;
        if (this.currentChunk.length == 0 || this.chunkIdx > this.currentChunk[0].length) {
            this.currentChunk = this.fetchChunk();
            this.chunkIdx = 1;
        }
        if (this.currentChunk.length == 0) {
            this.finished = true;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.resultRefLock.lock();
        try {
            if (this.isClosed()) {
                return;
            }
            DuckDBNative.duckdb_jdbc_free_result(this.resultRef);
            this.resultRef = null;
        }
        finally {
            this.resultRefLock.unlock();
        }
        if (this.stmt.closeOnCompletion) {
            this.stmt.close();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.resultRef == null;
    }

    private void check(int columnIndex) throws SQLException {
        this.checkOpen();
        if (columnIndex < 1 || columnIndex > this.meta.column_count) {
            throw new SQLException("Column index out of bounds");
        }
    }

    public synchronized Object arrowExportStream(Object arrow_buffer_allocator, long arrow_batch_size) throws SQLException {
        this.checkOpen();
        try {
            Class<?> buffer_allocator_class = Class.forName("org.apache.arrow.memory.BufferAllocator");
            if (!buffer_allocator_class.isInstance(arrow_buffer_allocator)) {
                throw new RuntimeException("Need to pass an Arrow BufferAllocator");
            }
            Long stream_pointer = DuckDBNative.duckdb_jdbc_arrow_stream(this.resultRef, arrow_batch_size);
            Class<?> arrow_array_stream_class = Class.forName("org.apache.arrow.c.ArrowArrayStream");
            Object arrow_array_stream = arrow_array_stream_class.getMethod("wrap", Long.TYPE).invoke(null, stream_pointer);
            Class<?> c_data_class = Class.forName("org.apache.arrow.c.Data");
            return c_data_class.getMethod("importArrayStream", buffer_allocator_class, arrow_array_stream_class).invoke(null, arrow_buffer_allocator, arrow_array_stream);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        return this.currentChunk[columnIndex - 1].getObject(this.chunkIdx - 1);
    }

    public Struct getStruct(int columnIndex) throws SQLException {
        return this.checkAndNull(columnIndex) ? null : this.currentChunk[columnIndex - 1].getStruct(this.chunkIdx - 1);
    }

    public OffsetTime getOffsetTime(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        return this.currentChunk[columnIndex - 1].getOffsetTime(this.chunkIdx - 1);
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet was closed");
        }
        return this.wasNull;
    }

    private boolean checkAndNull(int columnIndex) throws SQLException {
        this.check(columnIndex);
        try {
            this.wasNull = this.currentChunk[columnIndex - 1].check_and_null(this.chunkIdx - 1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SQLException("No row in context", e);
        }
        return this.wasNull;
    }

    public JsonNode getJsonObject(int columnIndex) throws SQLException {
        String result = this.getLazyString(columnIndex);
        return result == null ? null : new JsonNode(result);
    }

    public String getLazyString(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        return this.currentChunk[columnIndex - 1].getLazyString(this.chunkIdx - 1);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        Object res = this.getObject(columnIndex);
        if (res == null) {
            return null;
        }
        return res.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return false;
        }
        return this.currentChunk[columnIndex - 1].getBoolean(this.chunkIdx - 1);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return 0;
        }
        return this.currentChunk[columnIndex - 1].getByte(this.chunkIdx - 1);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return 0;
        }
        return this.currentChunk[columnIndex - 1].getShort(this.chunkIdx - 1);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return 0;
        }
        return this.currentChunk[columnIndex - 1].getInt(this.chunkIdx - 1);
    }

    private short getUint8(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return 0;
        }
        return this.currentChunk[columnIndex - 1].getUint8(this.chunkIdx - 1);
    }

    private int getUint16(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return 0;
        }
        return this.currentChunk[columnIndex - 1].getUint16(this.chunkIdx - 1);
    }

    private long getUint32(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return 0L;
        }
        return this.currentChunk[columnIndex - 1].getUint32(this.chunkIdx - 1);
    }

    private BigInteger getUint64(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return BigInteger.ZERO;
        }
        return this.currentChunk[columnIndex - 1].getUint64(this.chunkIdx - 1);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return 0L;
        }
        return this.currentChunk[columnIndex - 1].getLong(this.chunkIdx - 1);
    }

    public BigInteger getHugeint(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return BigInteger.ZERO;
        }
        return this.currentChunk[columnIndex - 1].getHugeint(this.chunkIdx - 1);
    }

    public BigInteger getUhugeint(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return BigInteger.ZERO;
        }
        return this.currentChunk[columnIndex - 1].getUhugeint(this.chunkIdx - 1);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return Float.NaN;
        }
        return this.currentChunk[columnIndex - 1].getFloat(this.chunkIdx - 1);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return Double.NaN;
        }
        return this.currentChunk[columnIndex - 1].getDouble(this.chunkIdx - 1);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkOpen();
        for (int col_idx = 0; col_idx < this.meta.column_count; ++col_idx) {
            if (!this.meta.column_names[col_idx].equalsIgnoreCase(columnLabel)) continue;
            return col_idx + 1;
        }
        throw new SQLException("Could not find column with label " + columnLabel);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBigDecimal");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        return this.currentChunk[columnIndex - 1].getBytes(this.chunkIdx - 1);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.checkAndNull(columnIndex) ? null : this.currentChunk[columnIndex - 1].getDate(this.chunkIdx - 1);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        return this.currentChunk[columnIndex - 1].getTimestamp(this.chunkIdx - 1);
    }

    private LocalDateTime getLocalDateTime(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        return this.currentChunk[columnIndex - 1].getLocalDateTime(this.chunkIdx - 1);
    }

    private OffsetDateTime getOffsetDateTime(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        return this.currentChunk[columnIndex - 1].getOffsetDateTime(this.chunkIdx - 1);
    }

    public UUID getUuid(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        return this.currentChunk[columnIndex - 1].getUuid(this.chunkIdx - 1);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        return this.currentChunk[columnIndex - 1].getBlob(this.chunkIdx - 1);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBinaryStream");
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBigDecimal");
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBytes");
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBinaryStream");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLFeatureNotSupportedException("getWarnings");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLFeatureNotSupportedException("clearWarnings");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException("getCursorName");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getCharacterStream");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getCharacterStream");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        return this.currentChunk[columnIndex - 1].getBigDecimal(this.chunkIdx - 1);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("isBeforeFirst");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("isAfterLast");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("isFirst");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("isLast");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("beforeFirst");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("afterLast");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLFeatureNotSupportedException("first");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLFeatureNotSupportedException("last");
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("getRow");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLFeatureNotSupportedException("absolute");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException("relative");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException("previous");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        if (direction != 1000 && direction != 1002) {
            throw new SQLFeatureNotSupportedException("setFetchDirection");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        if (rows < 0) {
            throw new SQLException("Fetch size has to be >= 0");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return DuckDBNative.duckdb_jdbc_fetch_size();
    }

    @Override
    public int getType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowUpdated");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowInserted");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowDeleted");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("insertRow");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRow");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("deleteRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("refreshRow");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("cancelRowUpdates");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("moveToInsertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("moveToCurrentRow");
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getClob");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        return this.currentChunk[columnIndex - 1].getArray(this.chunkIdx - 1);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getClob");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        return this.currentChunk[columnIndex - 1].getTime(this.chunkIdx - 1, cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        return this.currentChunk[columnIndex - 1].getTimestamp(this.chunkIdx - 1, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getURL");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getURL");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("getHoldability");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNString");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNString");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNCharacterStream");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    private boolean isTimestamp(DuckDBColumnType sqlType) {
        return sqlType == DuckDBColumnType.TIMESTAMP || sqlType == DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkOpen();
        if (type == null) {
            throw new SQLException("type is null");
        }
        if (this.checkAndNull(columnIndex)) {
            return null;
        }
        DuckDBColumnType sqlType = this.meta.column_types[columnIndex - 1];
        if (type == BigDecimal.class) {
            if (sqlType == DuckDBColumnType.DECIMAL) {
                return type.cast(this.getBigDecimal(columnIndex));
            }
            if (sqlType == DuckDBColumnType.FLOAT) {
                return type.cast(BigDecimal.valueOf(this.getFloat(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.DOUBLE) {
                return type.cast(BigDecimal.valueOf(this.getDouble(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.HUGEINT) {
                return type.cast(new BigDecimal(this.getHugeint(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.UHUGEINT) {
                return type.cast(new BigDecimal(this.getUhugeint(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.BIGINT) {
                return type.cast(BigDecimal.valueOf(this.getLong(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.UBIGINT) {
                return type.cast(new BigDecimal(this.getUint64(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.INTEGER) {
                return type.cast(BigDecimal.valueOf(this.getInt(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.UINTEGER) {
                return type.cast(BigDecimal.valueOf(this.getUint32(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.SMALLINT) {
                return type.cast(BigDecimal.valueOf(this.getShort(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.USMALLINT) {
                return type.cast(BigDecimal.valueOf(this.getUint16(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.TINYINT) {
                return type.cast(BigDecimal.valueOf(this.getByte(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.UTINYINT) {
                return type.cast(BigDecimal.valueOf(this.getUint8(columnIndex)));
            }
            throw new SQLException("Can't convert value to BigDecimal, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == String.class) {
            if (sqlType == DuckDBColumnType.VARCHAR || sqlType == DuckDBColumnType.ENUM) {
                return type.cast(this.getString(columnIndex));
            }
            throw new SQLException("Can't convert value to String, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == Boolean.class) {
            if (sqlType == DuckDBColumnType.BOOLEAN) {
                return type.cast(this.getBoolean(columnIndex));
            }
            throw new SQLException("Can't convert value to Boolean, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == Byte.class) {
            if (sqlType == DuckDBColumnType.TINYINT) {
                return type.cast(this.getByte(columnIndex));
            }
            throw new SQLException("Can't convert value to Byte, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == Short.class) {
            if (sqlType == DuckDBColumnType.SMALLINT) {
                return type.cast(this.getShort(columnIndex));
            }
            if (sqlType == DuckDBColumnType.TINYINT) {
                return type.cast(this.getByte(columnIndex));
            }
            if (sqlType == DuckDBColumnType.UTINYINT) {
                return type.cast(this.getUint8(columnIndex));
            }
            throw new SQLException("Can't convert value to Short, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == Integer.class) {
            if (sqlType == DuckDBColumnType.INTEGER) {
                return type.cast(this.getInt(columnIndex));
            }
            if (sqlType == DuckDBColumnType.SMALLINT) {
                return type.cast(this.getShort(columnIndex));
            }
            if (sqlType == DuckDBColumnType.USMALLINT) {
                return type.cast(this.getUint16(columnIndex));
            }
            if (sqlType == DuckDBColumnType.TINYINT) {
                return type.cast(this.getByte(columnIndex));
            }
            if (sqlType == DuckDBColumnType.UTINYINT) {
                return type.cast(this.getUint8(columnIndex));
            }
            throw new SQLException("Can't convert value to Integer, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == Long.class) {
            if (sqlType == DuckDBColumnType.BIGINT || this.isTimestamp(sqlType)) {
                return type.cast(this.getLong(columnIndex));
            }
            if (sqlType == DuckDBColumnType.INTEGER) {
                return type.cast(this.getInt(columnIndex));
            }
            if (sqlType == DuckDBColumnType.UINTEGER) {
                return type.cast(this.getUint32(columnIndex));
            }
            if (sqlType == DuckDBColumnType.SMALLINT) {
                return type.cast(this.getShort(columnIndex));
            }
            if (sqlType == DuckDBColumnType.USMALLINT) {
                return type.cast(this.getUint16(columnIndex));
            }
            if (sqlType == DuckDBColumnType.TINYINT) {
                return type.cast(this.getByte(columnIndex));
            }
            if (sqlType == DuckDBColumnType.UTINYINT) {
                return type.cast(this.getUint8(columnIndex));
            }
            throw new SQLException("Can't convert value to Long, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == Float.class) {
            if (sqlType == DuckDBColumnType.FLOAT) {
                return type.cast(Float.valueOf(this.getFloat(columnIndex)));
            }
            throw new SQLException("Can't convert value to Float, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == Double.class) {
            if (sqlType == DuckDBColumnType.DOUBLE) {
                return type.cast(this.getDouble(columnIndex));
            }
            throw new SQLException("Can't convert value to Double, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == Date.class) {
            if (sqlType == DuckDBColumnType.DATE) {
                return type.cast(this.getDate(columnIndex));
            }
            throw new SQLException("Can't convert value to Date, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == Time.class) {
            if (sqlType == DuckDBColumnType.TIME) {
                return type.cast(this.getTime(columnIndex));
            }
            throw new SQLException("Can't convert value to Time, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == Timestamp.class) {
            if (this.isTimestamp(sqlType)) {
                return type.cast(this.getTimestamp(columnIndex));
            }
            throw new SQLException("Can't convert value to Timestamp, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == LocalDate.class) {
            if (sqlType == DuckDBColumnType.DATE) {
                Date date = this.getDate(columnIndex);
                if (date == null) {
                    return null;
                }
                return type.cast(date.toLocalDate());
            }
            throw new SQLException("Can't convert value to LocalDate, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == LocalDateTime.class) {
            if (this.isTimestamp(sqlType)) {
                return type.cast(this.getLocalDateTime(columnIndex));
            }
            throw new SQLException("Can't convert value to LocalDateTime, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == BigInteger.class) {
            if (sqlType == DuckDBColumnType.HUGEINT) {
                return type.cast(this.getHugeint(columnIndex));
            }
            if (sqlType == DuckDBColumnType.UHUGEINT) {
                return type.cast(this.getUhugeint(columnIndex));
            }
            if (sqlType == DuckDBColumnType.BIGINT) {
                return type.cast(BigInteger.valueOf(this.getLong(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.UBIGINT) {
                return type.cast(this.getUint64(columnIndex));
            }
            if (sqlType == DuckDBColumnType.INTEGER) {
                return type.cast(BigInteger.valueOf(this.getInt(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.UINTEGER) {
                return type.cast(BigInteger.valueOf(this.getUint32(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.SMALLINT) {
                return type.cast(BigInteger.valueOf(this.getShort(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.USMALLINT) {
                return type.cast(BigInteger.valueOf(this.getUint16(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.TINYINT) {
                return type.cast(BigInteger.valueOf(this.getByte(columnIndex)));
            }
            if (sqlType == DuckDBColumnType.UTINYINT) {
                return type.cast(BigInteger.valueOf(this.getUint8(columnIndex)));
            }
            throw new SQLException("Can't convert value to BigInteger, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == OffsetDateTime.class) {
            if (sqlType == DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE) {
                return type.cast(this.getOffsetDateTime(columnIndex));
            }
            throw new SQLException("Can't convert value to OffsetDateTime, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
        }
        if (type == Blob.class) {
            if (sqlType == DuckDBColumnType.BLOB) {
                throw new SQLException("Can't convert value to Blob, Java type: " + type + ", SQL type: " + (Object)((Object)sqlType));
            }
            throw new SQLException("Can't convert value to Blob, SQL type: " + (Object)((Object)sqlType));
        }
        if (type == UUID.class) {
            if (sqlType == DuckDBColumnType.UUID || sqlType == DuckDBColumnType.VARCHAR) {
                return type.cast(this.getUuid(columnIndex));
            }
            throw new SQLException("Can't convert value to UUID, SQL type: " + (Object)((Object)sqlType));
        }
        throw new SQLException("Can't convert value to " + type + ", SQL type: " + (Object)((Object)sqlType));
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("type is null");
        }
        if (columnLabel == null || columnLabel.isEmpty()) {
            throw new SQLException("columnLabel is null");
        }
        int index = this.findColumn(columnLabel);
        return this.getObject(index, type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return JdbcUtils.unwrap(this, iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    boolean isFinished() {
        return this.finished;
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet was closed");
        }
    }

    private DuckDBVector[] fetchChunk() throws SQLException {
        this.conn.connRefLock.lock();
        try {
            this.conn.checkOpen();
            this.resultRefLock.lock();
            try {
                this.checkOpen();
                DuckDBVector[] duckDBVectorArray = DuckDBNative.duckdb_jdbc_fetch(this.resultRef, this.conn.connRef);
                this.resultRefLock.unlock();
                return duckDBVectorArray;
            }
            catch (Throwable throwable) {
                try {
                    this.resultRefLock.unlock();
                    throw throwable;
                }
                catch (SQLException e) {
                    this.close();
                    throw e;
                }
            }
        }
        finally {
            this.conn.connRefLock.unlock();
        }
    }

    public static class DuckDBBlobResult
    implements Blob {
        private final ByteBuffer buffer;

        public DuckDBBlobResult(ByteBuffer buffer_p) {
            buffer_p.position(0);
            buffer_p.order(ByteOrder.LITTLE_ENDIAN);
            this.buffer = buffer_p;
        }

        @Override
        public InputStream getBinaryStream() {
            return this.getBinaryStream(0L, this.length());
        }

        @Override
        public InputStream getBinaryStream(long pos, long length) {
            return new ByteBufferBackedInputStream(this.buffer);
        }

        @Override
        public byte[] getBytes(long pos, int length) throws SQLException {
            if (pos < 1L || length < 0) {
                throw new SQLException("Invalid position or length");
            }
            byte[] bytes = new byte[length];
            this.buffer.position((int)pos - 1);
            this.buffer.get(bytes, 0, length);
            return bytes;
        }

        @Override
        public long position(Blob pattern, long start) throws SQLException {
            throw new SQLFeatureNotSupportedException("position");
        }

        @Override
        public long position(byte[] pattern, long start) throws SQLException {
            throw new SQLFeatureNotSupportedException("position");
        }

        @Override
        public long length() {
            return this.buffer.capacity();
        }

        @Override
        public void free() {
        }

        @Override
        public OutputStream setBinaryStream(long pos) throws SQLException {
            throw new SQLFeatureNotSupportedException("setBinaryStream");
        }

        @Override
        public void truncate(long length) throws SQLException {
            throw new SQLFeatureNotSupportedException("truncate");
        }

        @Override
        public int setBytes(long pos, byte[] bytes) throws SQLException {
            throw new SQLFeatureNotSupportedException("setBytes");
        }

        @Override
        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            throw new SQLFeatureNotSupportedException("setBytes");
        }

        public String toString() {
            return "DuckDBBlobResult{buffer=" + this.buffer + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DuckDBBlobResult that = (DuckDBBlobResult)o;
            return Objects.equals(this.buffer, that.buffer);
        }

        public int hashCode() {
            return Objects.hash(this.buffer);
        }

        static class ByteBufferBackedInputStream
        extends InputStream {
            ByteBuffer buf;

            public ByteBufferBackedInputStream(ByteBuffer buf) {
                this.buf = buf;
            }

            @Override
            public int read() throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                return this.buf.get() & 0xFF;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                len = Math.min(len, this.buf.remaining());
                this.buf.get(bytes, off, len);
                return len;
            }
        }
    }
}

