/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ParameterMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.duckdb.DuckDBArray;
import org.duckdb.DuckDBColumnType;
import org.duckdb.DuckDBColumnTypeMetaData;
import org.duckdb.DuckDBParameterMetaData;
import org.duckdb.DuckDBResultSet;
import org.duckdb.DuckDBStruct;
import org.duckdb.JdbcUtils;
import org.duckdb.JsonNode;
import org.duckdb.StatementReturnType;

public class DuckDBResultSetMetaData
implements ResultSetMetaData {
    protected int param_count;
    protected int column_count;
    protected String[] column_names;
    protected String[] column_types_string;
    protected String[] column_types_details;
    protected DuckDBColumnType[] column_types;
    protected DuckDBColumnTypeMetaData[] column_types_meta;
    protected final StatementReturnType return_type;
    protected ParameterMetaData param_meta;

    public DuckDBResultSetMetaData(int param_count, int column_count, String[] column_names, String[] column_types_string, String[] column_types_details, String return_type, String[] param_types_string, String[] param_types_details) {
        this.param_count = param_count;
        this.column_count = column_count;
        this.column_names = column_names;
        this.return_type = StatementReturnType.valueOf(return_type);
        this.column_types_string = column_types_string;
        this.column_types_details = column_types_details;
        ArrayList<DuckDBColumnType> column_types_al = new ArrayList<DuckDBColumnType>(column_count);
        ArrayList<DuckDBColumnTypeMetaData> column_types_meta = new ArrayList<DuckDBColumnTypeMetaData>(column_count);
        for (String column_type_string : this.column_types_string) {
            column_types_al.add(DuckDBResultSetMetaData.TypeNameToType(column_type_string));
        }
        this.column_types = new DuckDBColumnType[column_count];
        this.column_types = column_types_al.toArray(this.column_types);
        for (String column_type_detail : this.column_types_details) {
            if (DuckDBResultSetMetaData.TypeNameToType(column_type_detail) == DuckDBColumnType.DECIMAL) {
                column_types_meta.add(DuckDBColumnTypeMetaData.parseColumnTypeMetadata(column_type_detail));
                continue;
            }
            column_types_meta.add(null);
        }
        this.column_types_meta = column_types_meta.toArray(new DuckDBColumnTypeMetaData[column_count]);
        ArrayList<DuckDBColumnType> param_types_al = new ArrayList<DuckDBColumnType>(param_count);
        ArrayList<DuckDBColumnTypeMetaData> param_types_meta_al = new ArrayList<DuckDBColumnTypeMetaData>(param_count);
        for (String param_type_string : param_types_string) {
            param_types_al.add(DuckDBResultSetMetaData.TypeNameToType(param_type_string));
        }
        DuckDBColumnType[] param_types = param_types_al.toArray(new DuckDBColumnType[param_count]);
        for (String param_type_detail : param_types_details) {
            if (DuckDBResultSetMetaData.TypeNameToType(param_type_detail) == DuckDBColumnType.DECIMAL) {
                param_types_meta_al.add(DuckDBColumnTypeMetaData.parseColumnTypeMetadata(param_type_detail));
                continue;
            }
            param_types_meta_al.add(null);
        }
        DuckDBColumnTypeMetaData[] param_types_meta = param_types_meta_al.toArray(new DuckDBColumnTypeMetaData[param_count]);
        this.param_meta = new DuckDBParameterMetaData(param_count, param_types_string, param_types, param_types_meta);
    }

    public static DuckDBColumnType TypeNameToType(String type_name) {
        if (type_name.endsWith("]")) {
            return type_name.endsWith("[]") ? DuckDBColumnType.LIST : DuckDBColumnType.ARRAY;
        }
        if (type_name.startsWith("DECIMAL")) {
            return DuckDBColumnType.DECIMAL;
        }
        if (type_name.equals("TIME WITH TIME ZONE")) {
            return DuckDBColumnType.TIME_WITH_TIME_ZONE;
        }
        if (type_name.equals("TIMESTAMP WITH TIME ZONE")) {
            return DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE;
        }
        if (type_name.startsWith("STRUCT")) {
            return DuckDBColumnType.STRUCT;
        }
        if (type_name.startsWith("MAP")) {
            return DuckDBColumnType.MAP;
        }
        if (type_name.startsWith("UNION")) {
            return DuckDBColumnType.UNION;
        }
        try {
            return DuckDBColumnType.valueOf(type_name);
        }
        catch (IllegalArgumentException e) {
            return DuckDBColumnType.UNKNOWN;
        }
    }

    public StatementReturnType getReturnType() {
        return this.return_type;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.column_count;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (column > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return this.column_names[column - 1];
    }

    public static int type_to_int(DuckDBColumnType type) {
        switch (type) {
            case BOOLEAN: {
                return 16;
            }
            case TINYINT: {
                return -6;
            }
            case SMALLINT: {
                return 5;
            }
            case INTEGER: {
                return 4;
            }
            case BIGINT: {
                return -5;
            }
            case LIST: 
            case ARRAY: {
                return 2003;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 8;
            }
            case DECIMAL: {
                return 3;
            }
            case VARCHAR: {
                return 12;
            }
            case TIME: {
                return 92;
            }
            case DATE: {
                return 91;
            }
            case TIMESTAMP_S: 
            case TIMESTAMP_MS: 
            case TIMESTAMP: 
            case TIMESTAMP_NS: {
                return 93;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return 2014;
            }
            case TIME_WITH_TIME_ZONE: {
                return 2013;
            }
            case STRUCT: {
                return 2002;
            }
            case BIT: {
                return -7;
            }
            case BLOB: {
                return 2004;
            }
        }
        return 2000;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (column > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return DuckDBResultSetMetaData.type_to_int(this.column_types[column - 1]);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        if (column > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return DuckDBResultSetMetaData.type_to_javaString(this.column_types[column - 1]);
    }

    protected static String type_to_javaString(DuckDBColumnType type) {
        switch (type) {
            case BOOLEAN: {
                return Boolean.class.getName();
            }
            case TINYINT: {
                return Byte.class.getName();
            }
            case SMALLINT: 
            case UTINYINT: {
                return Short.class.getName();
            }
            case INTEGER: 
            case USMALLINT: {
                return Integer.class.getName();
            }
            case BIGINT: 
            case UINTEGER: {
                return Long.class.getName();
            }
            case HUGEINT: 
            case UHUGEINT: 
            case UBIGINT: {
                return BigInteger.class.getName();
            }
            case FLOAT: {
                return Float.class.getName();
            }
            case DOUBLE: {
                return Double.class.getName();
            }
            case DECIMAL: {
                return BigDecimal.class.getName();
            }
            case TIME: {
                return LocalTime.class.getName();
            }
            case TIME_WITH_TIME_ZONE: {
                return OffsetTime.class.getName();
            }
            case DATE: {
                return LocalDate.class.getName();
            }
            case TIMESTAMP_S: 
            case TIMESTAMP_MS: 
            case TIMESTAMP: 
            case TIMESTAMP_NS: {
                return Timestamp.class.getName();
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return OffsetDateTime.class.getName();
            }
            case JSON: {
                return JsonNode.class.getName();
            }
            case BLOB: {
                return DuckDBResultSet.DuckDBBlobResult.class.getName();
            }
            case UUID: {
                return UUID.class.getName();
            }
            case LIST: 
            case ARRAY: {
                return DuckDBArray.class.getName();
            }
            case MAP: {
                return HashMap.class.getName();
            }
            case STRUCT: {
                return DuckDBStruct.class.getName();
            }
        }
        return String.class.getName();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (column > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return this.column_types_string[column - 1];
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        if (column > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return DuckDBResultSetMetaData.is_signed(this.column_types[column - 1]);
    }

    protected static boolean is_signed(DuckDBColumnType type) {
        switch (type) {
            case UTINYINT: 
            case USMALLINT: 
            case UINTEGER: 
            case UHUGEINT: 
            case UBIGINT: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        DuckDBColumnTypeMetaData typeMetaData = this.typeMetadataForColumn(column);
        if (typeMetaData == null) {
            return 0;
        }
        return typeMetaData.width;
    }

    @Override
    public int getScale(int column) throws SQLException {
        DuckDBColumnTypeMetaData typeMetaData = this.typeMetadataForColumn(column);
        if (typeMetaData == null) {
            return 0;
        }
        return typeMetaData.scale;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return JdbcUtils.unwrap(this, iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    private DuckDBColumnTypeMetaData typeMetadataForColumn(int columnIndex) throws SQLException {
        if (columnIndex > this.column_count) {
            throw new SQLException("Column index out of bounds");
        }
        return this.column_types_meta[columnIndex - 1];
    }
}

