/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

final class JdbcUtils {
    static <T> T unwrap(Object object, Class<T> clazz) throws SQLException {
        if (!clazz.isInstance(object)) {
            throw new SQLException(object.getClass().getName() + " not unwrappable from " + clazz.getName());
        }
        return (T)object;
    }

    static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[256];
        int n2 = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, n2, n);
            n2 += n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private JdbcUtils() {
    }
}

