/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import org.duckdb.DuckDBArrayResultSet;
import org.duckdb.DuckDBResultSetMetaData;
import org.duckdb.DuckDBVector;

public class DuckDBArray
implements Array {
    private final Object[] array;
    private final DuckDBVector vector;
    final int offset;
    final int length;

    DuckDBArray(DuckDBVector duckDBVector, int n, int n2) throws SQLException {
        this.vector = duckDBVector;
        this.length = n2;
        this.offset = n;
        this.array = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            this.array[i] = duckDBVector.getObject(n + i);
        }
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public Object getArray() throws SQLException {
        return this.array;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArray();
    }

    @Override
    public Object getArray(long l, int n) throws SQLException {
        throw new UnsupportedOperationException("Unimplemented method 'getArray'");
    }

    @Override
    public Object getArray(long l, int n, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Unimplemented method 'getArray'");
    }

    @Override
    public int getBaseType() throws SQLException {
        return DuckDBResultSetMetaData.type_to_int(this.vector.duckdb_type);
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.vector.duckdb_type.name();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return new DuckDBArrayResultSet(this.vector, this.offset, this.length);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Unimplemented method 'getResultSet'");
    }

    @Override
    public ResultSet getResultSet(long l, int n) throws SQLException {
        throw new UnsupportedOperationException("Unimplemented method 'getResultSet'");
    }

    @Override
    public ResultSet getResultSet(long l, int n, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Unimplemented method 'getResultSet'");
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

