/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.Properties;
import org.duckdb.DuckDBConnection;
import org.duckdb.DuckDBResultSetMetaData;
import org.duckdb.DuckDBVector;

public class DuckDBNative {
    protected static native ByteBuffer duckdb_jdbc_startup(byte[] var0, boolean var1, Properties var2) throws SQLException;

    protected static native ByteBuffer duckdb_jdbc_connect(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_set_auto_commit(ByteBuffer var0, boolean var1) throws SQLException;

    protected static native boolean duckdb_jdbc_get_auto_commit(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_disconnect(ByteBuffer var0);

    protected static native void duckdb_jdbc_set_schema(ByteBuffer var0, String var1);

    protected static native void duckdb_jdbc_set_catalog(ByteBuffer var0, String var1);

    protected static native String duckdb_jdbc_get_schema(ByteBuffer var0);

    protected static native String duckdb_jdbc_get_catalog(ByteBuffer var0);

    protected static native ByteBuffer duckdb_jdbc_prepare(ByteBuffer var0, byte[] var1) throws SQLException;

    protected static native void duckdb_jdbc_release(ByteBuffer var0);

    protected static native DuckDBResultSetMetaData duckdb_jdbc_meta(ByteBuffer var0) throws SQLException;

    protected static native ByteBuffer duckdb_jdbc_execute(ByteBuffer var0, Object[] var1) throws SQLException;

    protected static native void duckdb_jdbc_free_result(ByteBuffer var0);

    protected static native DuckDBVector[] duckdb_jdbc_fetch(ByteBuffer var0, ByteBuffer var1) throws SQLException;

    protected static native int duckdb_jdbc_fetch_size();

    protected static native long duckdb_jdbc_arrow_stream(ByteBuffer var0, long var1);

    protected static native void duckdb_jdbc_arrow_register(ByteBuffer var0, long var1, byte[] var3);

    protected static native ByteBuffer duckdb_jdbc_create_appender(ByteBuffer var0, byte[] var1, byte[] var2) throws SQLException;

    protected static native void duckdb_jdbc_appender_begin_row(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_appender_end_row(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_appender_flush(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_interrupt(ByteBuffer var0);

    protected static native void duckdb_jdbc_appender_close(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_boolean(ByteBuffer var0, boolean var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_byte(ByteBuffer var0, byte var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_short(ByteBuffer var0, short var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_int(ByteBuffer var0, int var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_long(ByteBuffer var0, long var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_float(ByteBuffer var0, float var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_double(ByteBuffer var0, double var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_string(ByteBuffer var0, byte[] var1) throws SQLException;

    protected static native void duckdb_jdbc_appender_append_null(ByteBuffer var0) throws SQLException;

    protected static native void duckdb_jdbc_create_extension_type(ByteBuffer var0) throws SQLException;

    public static void duckdb_jdbc_create_extension_type(DuckDBConnection duckDBConnection) throws SQLException {
        DuckDBNative.duckdb_jdbc_create_extension_type(duckDBConnection.conn_ref);
    }

    static {
        try {
            String string;
            String string2;
            String string3 = "";
            String string4 = System.getProperty("os.name").toLowerCase().trim();
            switch (string2 = System.getProperty("os.arch").toLowerCase().trim()) {
                case "x86_64": 
                case "amd64": {
                    string = "amd64";
                    break;
                }
                case "aarch64": 
                case "arm64": {
                    string = "arm64";
                    break;
                }
                case "i386": {
                    string = "i386";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported system architecture");
                }
            }
            if (string4.startsWith("windows")) {
                string3 = "windows";
            } else if (string4.startsWith("mac")) {
                string3 = "osx";
                string = "universal";
            } else if (string4.startsWith("linux")) {
                string3 = "linux";
            }
            String string5 = "/libduckdb_java.so_" + string3 + "_" + string;
            Path path = Files.createTempFile("libduckdb_java", ".so", new FileAttribute[0]);
            URL uRL = DuckDBNative.class.getResource(string5);
            if (uRL == null) {
                throw new IOException(string5 + " not found");
            }
            Files.copy(uRL.openStream(), path, StandardCopyOption.REPLACE_EXISTING);
            new File(path.toString()).deleteOnExit();
            System.load(path.toAbsolutePath().toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

