/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb.test;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import org.duckdb.DuckDBAppender;
import org.duckdb.DuckDBConnection;
import org.duckdb.DuckDBDatabase;
import org.duckdb.DuckDBDriver;

public class TestDuckDBJDBC {
    private static void assertTrue(boolean bl) throws Exception {
        if (!bl) {
            throw new Exception();
        }
    }

    private static void assertFalse(boolean bl) throws Exception {
        TestDuckDBJDBC.assertTrue(!bl);
    }

    private static void assertEquals(Object object, Object object2) throws Exception {
        if (object == null && object2 == null) {
            return;
        }
        TestDuckDBJDBC.assertTrue(object.equals(object2));
    }

    private static void assertNull(Object object) throws Exception {
        TestDuckDBJDBC.assertTrue(object == null);
    }

    private static void assertEquals(double d, double d2, double d3) throws Exception {
        TestDuckDBJDBC.assertTrue(Math.abs(d - d2) < d3);
    }

    private static void fail() throws Exception {
        TestDuckDBJDBC.assertTrue(false);
    }

    public static void test_connection() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        TestDuckDBJDBC.assertTrue(connection.isValid(0));
        TestDuckDBJDBC.assertFalse(connection.isClosed());
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 42 as a");
        TestDuckDBJDBC.assertFalse(statement.isClosed());
        TestDuckDBJDBC.assertFalse(resultSet.isClosed());
        TestDuckDBJDBC.assertTrue(resultSet.next());
        int n = resultSet.getInt(1);
        TestDuckDBJDBC.assertEquals(n, 42);
        TestDuckDBJDBC.assertFalse(resultSet.wasNull());
        n = resultSet.getInt(1);
        TestDuckDBJDBC.assertEquals(n, 42);
        TestDuckDBJDBC.assertFalse(resultSet.wasNull());
        n = resultSet.getInt("a");
        TestDuckDBJDBC.assertEquals(n, 42);
        TestDuckDBJDBC.assertFalse(resultSet.wasNull());
        try {
            n = resultSet.getInt(0);
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            n = resultSet.getInt(2);
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            n = resultSet.getInt("b");
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        TestDuckDBJDBC.assertFalse(resultSet.next());
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet.close();
        TestDuckDBJDBC.assertTrue(resultSet.isClosed());
        try {
            n = resultSet.getInt(1);
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.close();
        statement.close();
        TestDuckDBJDBC.assertTrue(statement.isClosed());
        connection.close();
        connection.close();
        TestDuckDBJDBC.assertFalse(connection.isValid(0));
        TestDuckDBJDBC.assertTrue(connection.isClosed());
        try {
            statement = connection.createStatement();
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void test_result() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT CAST(42 AS INTEGER) as a, CAST(4.2 AS DOUBLE) as b");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        TestDuckDBJDBC.assertEquals(resultSetMetaData.getColumnCount(), 2);
        TestDuckDBJDBC.assertEquals(resultSetMetaData.getColumnName(1), "a");
        TestDuckDBJDBC.assertEquals(resultSetMetaData.getColumnName(2), "b");
        TestDuckDBJDBC.assertEquals(resultSetMetaData.getColumnTypeName(1), "INTEGER");
        TestDuckDBJDBC.assertEquals(resultSetMetaData.getColumnTypeName(2), "DOUBLE");
        try {
            resultSetMetaData.getColumnName(0);
            TestDuckDBJDBC.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            resultSetMetaData.getColumnTypeName(0);
            TestDuckDBJDBC.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            resultSetMetaData.getColumnName(3);
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            resultSetMetaData.getColumnTypeName(3);
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getInt(1), 42);
        TestDuckDBJDBC.assertEquals(resultSet.getString(1), "42");
        TestDuckDBJDBC.assertEquals(resultSet.getDouble(1), 42.0, 0.001);
        TestDuckDBJDBC.assertTrue(resultSet.getObject(1).equals(new Integer(42)));
        TestDuckDBJDBC.assertEquals(resultSet.getInt("a"), 42);
        TestDuckDBJDBC.assertEquals(resultSet.getString("a"), "42");
        TestDuckDBJDBC.assertEquals(resultSet.getDouble("a"), 42.0, 0.001);
        TestDuckDBJDBC.assertTrue(resultSet.getObject("a").equals(new Integer(42)));
        TestDuckDBJDBC.assertEquals(resultSet.getInt(2), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "4.2");
        TestDuckDBJDBC.assertEquals(resultSet.getDouble(2), 4.2, 0.001);
        TestDuckDBJDBC.assertTrue(resultSet.getObject(2).equals(new Double(4.2)));
        TestDuckDBJDBC.assertEquals(resultSet.getInt("b"), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getString("b"), "4.2");
        TestDuckDBJDBC.assertEquals(resultSet.getDouble("b"), 4.2, 0.001);
        TestDuckDBJDBC.assertTrue(resultSet.getObject("b").equals(new Double(4.2)));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        Connection connection2 = ((DuckDBConnection)connection).duplicate();
        ResultSet resultSet2 = connection2.createStatement().executeQuery("SELECT 42");
        resultSet2.next();
        TestDuckDBJDBC.assertEquals(42, resultSet2.getInt(1));
        resultSet2.close();
        connection.close();
        connection2.close();
    }

    public static void test_empty_table() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE a (i iNTEGER)");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM a");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        try {
            resultSet.getObject(1);
            TestDuckDBJDBC.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_broken_next() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE t0(c0 INT8, c1 VARCHAR)");
        statement.execute("INSERT INTO t0(c1, c0) VALUES (-315929644, 1), (-315929644, -315929644), (-634993846, -1981637379)");
        statement.execute("INSERT INTO t0(c0, c1) VALUES (-433000283, -433000283)");
        statement.execute("INSERT INTO t0(c0) VALUES (-995217820)");
        statement.execute("INSERT INTO t0(c1, c0) VALUES (-315929644, -315929644)");
        ResultSet resultSet = statement.executeQuery("SELECT c0 FROM t0");
        while (resultSet.next()) {
            TestDuckDBJDBC.assertTrue(!resultSet.getObject(1).equals(null));
        }
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_multiple_connections() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        Connection connection2 = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement2 = connection2.createStatement();
        Statement statement3 = connection2.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 42");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(42, resultSet.getInt(1));
        resultSet.close();
        ResultSet resultSet2 = statement2.executeQuery("SELECT 43");
        TestDuckDBJDBC.assertTrue(resultSet2.next());
        TestDuckDBJDBC.assertEquals(43, resultSet2.getInt(1));
        ResultSet resultSet3 = statement3.executeQuery("SELECT 44");
        TestDuckDBJDBC.assertTrue(resultSet3.next());
        TestDuckDBJDBC.assertEquals(44, resultSet3.getInt(1));
        resultSet3.close();
        statement2.close();
        resultSet3 = statement3.executeQuery("SELECT 44");
        TestDuckDBJDBC.assertTrue(resultSet3.next());
        TestDuckDBJDBC.assertEquals(44, resultSet3.getInt(1));
        statement2.close();
        resultSet2.close();
        resultSet3.close();
        System.gc();
        System.gc();
        resultSet = statement.executeQuery("SELECT 42");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(42, resultSet.getInt(1));
        resultSet.close();
        resultSet3 = statement3.executeQuery("SELECT 42");
        TestDuckDBJDBC.assertTrue(resultSet3.next());
        TestDuckDBJDBC.assertEquals(42, resultSet3.getInt(1));
        resultSet3.close();
        connection2.close();
        statement3.close();
        resultSet2 = null;
        resultSet3 = null;
        statement2 = null;
        statement3 = null;
        connection2 = null;
        System.gc();
        System.gc();
        resultSet = statement.executeQuery("SELECT 42");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(42, resultSet.getInt(1));
        resultSet.close();
        connection.close();
        statement.close();
    }

    public static void test_big_data() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        int n = 10000;
        statement.execute("CREATE TABLE a (i iNTEGER)");
        for (int i = 0; i < n; ++i) {
            statement.execute("INSERT INTO a VALUES (" + i + ")");
        }
        ResultSet resultSet = statement.executeQuery("SELECT CAST(i AS SMALLINT), CAST(i AS INTEGER), CAST(i AS BIGINT), CAST(i AS FLOAT), CAST(i AS DOUBLE), CAST(i as STRING), NULL FROM a");
        int n2 = 0;
        while (resultSet.next()) {
            int n3;
            for (n3 = 1; n3 <= 6; ++n3) {
                TestDuckDBJDBC.assertEquals(resultSet.getShort(n3), (short)n2);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
                TestDuckDBJDBC.assertEquals(resultSet.getInt(n3), n2);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
                TestDuckDBJDBC.assertEquals(resultSet.getLong(n3), n2);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
                TestDuckDBJDBC.assertEquals(resultSet.getFloat(n3), n2, 0.001);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
                TestDuckDBJDBC.assertEquals(resultSet.getDouble(n3), n2, 0.001);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
                TestDuckDBJDBC.assertEquals(Double.parseDouble(resultSet.getString(n3)), n2, 0.001);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
                Object object = resultSet.getObject(n3);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
            }
            n3 = resultSet.getShort(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            int n4 = resultSet.getInt(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            long l = resultSet.getLong(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            float f = resultSet.getFloat(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            double d = resultSet.getDouble(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            String string = resultSet.getString(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            Object object = resultSet.getObject(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            ++n2;
        }
        TestDuckDBJDBC.assertEquals(n, n2);
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_crash_bug496() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE t0(c0 BOOLEAN, c1 INT)");
        statement.execute("CREATE INDEX i0 ON t0(c1, c0)");
        statement.execute("INSERT INTO t0(c1) VALUES (0)");
        statement.close();
        connection.close();
    }

    public static void test_tablepragma_bug491() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE t0(c0 INT)");
        ResultSet resultSet = statement.executeQuery("PRAGMA table_info('t0')");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getInt("cid"), 0);
        TestDuckDBJDBC.assertEquals(resultSet.getString("name"), "c0");
        TestDuckDBJDBC.assertEquals(resultSet.getString("type"), "INTEGER");
        TestDuckDBJDBC.assertEquals(resultSet.getBoolean("notnull"), false);
        resultSet.getString("dflt_value");
        TestDuckDBJDBC.assertEquals(resultSet.getBoolean("pk"), false);
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_nulltruth_bug489() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE t0(c0 INT)");
        statement.execute("INSERT INTO t0(c0) VALUES (0)");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t0 WHERE NOT(NULL OR TRUE)");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet = statement.executeQuery("SELECT NOT(NULL OR TRUE)");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        boolean bl = resultSet.getBoolean(1);
        TestDuckDBJDBC.assertEquals(bl, false);
        TestDuckDBJDBC.assertFalse(resultSet.wasNull());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_empty_prepare_bug500() throws Exception {
        String string = "CREATE TABLE t0(c0 VARCHAR, c1 DOUBLE);\nCREATE TABLE t1(c0 DOUBLE, PRIMARY KEY(c0));\nINSERT INTO t0(c0) VALUES (0), (0), (0), (0);\nINSERT INTO t0(c0) VALUES (NULL), (NULL);\nINSERT INTO t1(c0) VALUES (0), (1);\n\nSELECT t0.c0 FROM t0, t1;";
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        for (String string2 : string.split("\n")) {
            Statement statement = connection.createStatement();
            try {
                statement.execute(string2);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        connection.close();
    }

    public static void test_borked_string_bug539() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE t0 (c0 VARCHAR)");
        String string = String.format("INSERT INTO t0 VALUES('%c')", 55995);
        statement.executeUpdate(string);
        statement.close();
        connection.close();
    }

    public static void test_prepare_types() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CAST(? AS BOOLEAN) c1, CAST(? AS TINYINT) c2, CAST(? AS SMALLINT) c3, CAST(? AS INTEGER) c4, CAST(? AS BIGINT) c5, CAST(? AS FLOAT) c6, CAST(? AS DOUBLE) c7, CAST(? AS STRING) c8");
        preparedStatement.setBoolean(1, true);
        preparedStatement.setByte(2, (byte)42);
        preparedStatement.setShort(3, (short)43);
        preparedStatement.setInt(4, 44);
        preparedStatement.setLong(5, 45L);
        preparedStatement.setFloat(6, 4.6f);
        preparedStatement.setDouble(7, 4.7);
        preparedStatement.setString(8, "four eight");
        ResultSet resultSet = preparedStatement.executeQuery();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getBoolean(1), true);
        TestDuckDBJDBC.assertEquals(resultSet.getByte(2), (byte)42);
        TestDuckDBJDBC.assertEquals(resultSet.getShort(3), (short)43);
        TestDuckDBJDBC.assertEquals(resultSet.getInt(4), 44);
        TestDuckDBJDBC.assertEquals(resultSet.getLong(5), 45L);
        TestDuckDBJDBC.assertEquals(resultSet.getFloat(6), 4.6, 0.001);
        TestDuckDBJDBC.assertEquals(resultSet.getDouble(7), 4.7, 0.001);
        TestDuckDBJDBC.assertEquals(resultSet.getString(8), "four eight");
        resultSet.close();
        preparedStatement.setBoolean(1, false);
        preparedStatement.setByte(2, (byte)82);
        preparedStatement.setShort(3, (short)83);
        preparedStatement.setInt(4, 84);
        preparedStatement.setLong(5, 85L);
        preparedStatement.setFloat(6, 8.6f);
        preparedStatement.setDouble(7, 8.7);
        preparedStatement.setString(8, "eight eight");
        resultSet = preparedStatement.executeQuery();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getBoolean(1), false);
        TestDuckDBJDBC.assertEquals(resultSet.getByte(2), (byte)82);
        TestDuckDBJDBC.assertEquals(resultSet.getShort(3), (short)83);
        TestDuckDBJDBC.assertEquals(resultSet.getInt(4), 84);
        TestDuckDBJDBC.assertEquals(resultSet.getLong(5), 85L);
        TestDuckDBJDBC.assertEquals(resultSet.getFloat(6), 8.6, 0.001);
        TestDuckDBJDBC.assertEquals(resultSet.getDouble(7), 8.7, 0.001);
        TestDuckDBJDBC.assertEquals(resultSet.getString(8), "eight eight");
        resultSet.close();
        preparedStatement.setObject(1, false);
        preparedStatement.setObject(2, (byte)82);
        preparedStatement.setObject(3, (short)83);
        preparedStatement.setObject(4, 84);
        preparedStatement.setObject(5, 85L);
        preparedStatement.setObject(6, Float.valueOf(8.6f));
        preparedStatement.setObject(7, 8.7);
        preparedStatement.setObject(8, "eight eight");
        resultSet = preparedStatement.executeQuery();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getBoolean(1), false);
        TestDuckDBJDBC.assertEquals(resultSet.getByte(2), (byte)82);
        TestDuckDBJDBC.assertEquals(resultSet.getShort(3), (short)83);
        TestDuckDBJDBC.assertEquals(resultSet.getInt(4), 84);
        TestDuckDBJDBC.assertEquals(resultSet.getLong(5), 85L);
        TestDuckDBJDBC.assertEquals(resultSet.getFloat(6), 8.6, 0.001);
        TestDuckDBJDBC.assertEquals(resultSet.getDouble(7), 8.7, 0.001);
        TestDuckDBJDBC.assertEquals(resultSet.getString(8), "eight eight");
        preparedStatement.setNull(1, 0);
        preparedStatement.setNull(2, 0);
        preparedStatement.setNull(3, 0);
        preparedStatement.setNull(4, 0);
        preparedStatement.setNull(5, 0);
        preparedStatement.setNull(6, 0);
        preparedStatement.setNull(7, 0);
        preparedStatement.setNull(8, 0);
        resultSet = preparedStatement.executeQuery();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(8, resultSet.getMetaData().getColumnCount());
        for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
            TestDuckDBJDBC.assertNull(resultSet.getObject(i));
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            TestDuckDBJDBC.assertNull(resultSet.getString(i));
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
        }
        resultSet.close();
        preparedStatement.close();
        connection.close();
    }

    public static void test_prepare_insert() throws Exception {
        int n;
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        connection.createStatement().executeUpdate("create table ctstable1 (TYPE_ID int, TYPE_DESC varchar(32), primary key(TYPE_ID))");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into ctstable1 values(?, ?)");
        int n2 = 1;
        while (n2 <= 10) {
            String string = "Type-" + n2;
            n = n2++;
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            int n3 = preparedStatement.executeUpdate();
            TestDuckDBJDBC.assertEquals(n3, 1);
        }
        preparedStatement.close();
        connection.createStatement().executeUpdate("create table ctstable2 (KEY_ID int, COF_NAME varchar(32), PRICE float, TYPE_ID int, primary key(KEY_ID) )");
        PreparedStatement preparedStatement2 = connection.prepareStatement("insert into ctstable2 values(?, ?, ?, ?)");
        for (int i = 1; i <= 10; ++i) {
            n = i;
            String string = "xx-" + i;
            float f = (float)i + 0.0f;
            int n4 = i % 5;
            if (n4 == 0) {
                n4 = 5;
            }
            preparedStatement2.setInt(1, n);
            preparedStatement2.setString(2, string);
            preparedStatement2.setFloat(3, f);
            preparedStatement2.setInt(4, n4);
            preparedStatement2.executeUpdate();
        }
        preparedStatement2.close();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM ctstable1");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getInt(1), 10);
        resultSet.close();
        statement.executeUpdate("DELETE FROM ctstable1");
        resultSet = statement.executeQuery("SELECT COUNT(*) FROM ctstable1");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getInt(1), 0);
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_read_only() throws Exception {
        AutoCloseable autoCloseable;
        Object object;
        Path path = Files.createTempFile("duckdb-jdbc-test-", ".duckdb", new FileAttribute[0]);
        path.toFile().delete();
        String string = "jdbc:duckdb:" + path.toString();
        Properties properties = new Properties();
        properties.setProperty("duckdb.read_only", "true");
        Connection connection = DriverManager.getConnection(string);
        TestDuckDBJDBC.assertFalse(connection.isReadOnly());
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE test (i INTEGER)");
        statement.execute("INSERT INTO test VALUES (42)");
        statement.close();
        try {
            object = DriverManager.getConnection(string);
            TestDuckDBJDBC.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = DriverManager.getConnection(string, properties);
            TestDuckDBJDBC.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = ((DuckDBConnection)connection).getDatabase();
        connection.close();
        ((DuckDBDatabase)object).shutdown();
        try {
            autoCloseable = connection.createStatement();
            autoCloseable.executeQuery("SELECT 42");
            autoCloseable.close();
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            autoCloseable = ((DuckDBConnection)connection).duplicate();
            autoCloseable.close();
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void test_hugeint() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 42::hugeint hi1, -42::hugeint hi2, 454564646545646546545646545::hugeint hi3, -454564646545646546545646545::hugeint hi4");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getObject("hi1"), new BigInteger("42"));
        TestDuckDBJDBC.assertEquals(resultSet.getObject("hi2"), new BigInteger("-42"));
        TestDuckDBJDBC.assertEquals(resultSet.getLong("hi1"), 42L);
        TestDuckDBJDBC.assertEquals(resultSet.getLong("hi2"), -42L);
        TestDuckDBJDBC.assertEquals(resultSet.getObject("hi3"), new BigInteger("454564646545646546545646545"));
        TestDuckDBJDBC.assertEquals(resultSet.getObject("hi4"), new BigInteger("-454564646545646546545646545"));
        TestDuckDBJDBC.assertEquals(resultSet.getBigDecimal("hi1"), new BigDecimal("42"));
        TestDuckDBJDBC.assertEquals(resultSet.getBigDecimal("hi2"), new BigDecimal("-42"));
        TestDuckDBJDBC.assertEquals(resultSet.getBigDecimal("hi3"), new BigDecimal("454564646545646546545646545"));
        TestDuckDBJDBC.assertEquals(resultSet.getBigDecimal("hi4"), new BigDecimal("-454564646545646546545646545"));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_exotic_types() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT '2019-11-26 21:11:00'::timestamp ts, '2019-11-26'::date dt, interval '5 days' iv, '21:11:00'::time te");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getObject("ts"), Timestamp.valueOf("2019-11-26 21:11:00"));
        TestDuckDBJDBC.assertEquals(resultSet.getTimestamp("ts"), Timestamp.valueOf("2019-11-26 21:11:00"));
        TestDuckDBJDBC.assertEquals(resultSet.getObject("dt"), Date.valueOf("2019-11-26"));
        TestDuckDBJDBC.assertEquals(resultSet.getDate("dt"), Date.valueOf("2019-11-26"));
        TestDuckDBJDBC.assertEquals(resultSet.getObject("iv"), "5 days");
        TestDuckDBJDBC.assertEquals(resultSet.getObject("te"), Time.valueOf("21:11:00"));
        TestDuckDBJDBC.assertEquals(resultSet.getTime("te"), Time.valueOf("21:11:00"));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_exotic_nulls() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT NULL::timestamp ts, NULL::date dt, NULL::time te");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("ts"));
        TestDuckDBJDBC.assertNull(resultSet.getTimestamp("ts"));
        TestDuckDBJDBC.assertNull(resultSet.getObject("dt"));
        TestDuckDBJDBC.assertNull(resultSet.getDate("dt"));
        TestDuckDBJDBC.assertNull(resultSet.getObject("te"));
        TestDuckDBJDBC.assertNull(resultSet.getTime("te"));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_evil_date() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT '5131-08-05 (BC)'::date d");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getDate("d"));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_decimal() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT '1.23'::decimal(3,2) d");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getDouble("d"), 1.23);
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_schema_reflection() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE a (i INTEGER)");
        statement.execute("CREATE VIEW b AS SELECT i::STRING AS j FROM a");
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTableTypes();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_TYPE"), "BASE TABLE");
        TestDuckDBJDBC.assertEquals(resultSet.getString(1), "BASE TABLE");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_TYPE"), "VIEW");
        TestDuckDBJDBC.assertEquals(resultSet.getString(1), "VIEW");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getCatalogs();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getSchemas(null, "ma%");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CATALOG"));
        TestDuckDBJDBC.assertEquals(resultSet.getString(1), "main");
        TestDuckDBJDBC.assertNull(resultSet.getObject(2));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getSchemas(null, "xxx");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getTables(null, null, "%", null);
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_TYPE"), "BASE TABLE");
        TestDuckDBJDBC.assertEquals(resultSet.getString(4), "BASE TABLE");
        TestDuckDBJDBC.assertNull(resultSet.getObject("REMARKS"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(5));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(6));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_SCHEM"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(7));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_NAME"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(8));
        TestDuckDBJDBC.assertNull(resultSet.getObject("SELF_REFERENCING_COL_NAME"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(9));
        TestDuckDBJDBC.assertNull(resultSet.getObject("REF_GENERATION"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(10));
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "b");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "b");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_TYPE"), "VIEW");
        TestDuckDBJDBC.assertEquals(resultSet.getString(4), "VIEW");
        TestDuckDBJDBC.assertNull(resultSet.getObject("REMARKS"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(5));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(6));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_SCHEM"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(7));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_NAME"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(8));
        TestDuckDBJDBC.assertNull(resultSet.getObject("SELF_REFERENCING_COL_NAME"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(9));
        TestDuckDBJDBC.assertNull(resultSet.getObject("REF_GENERATION"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(10));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getTables(null, "main", "a", null);
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_TYPE"), "BASE TABLE");
        TestDuckDBJDBC.assertEquals(resultSet.getString(4), "BASE TABLE");
        TestDuckDBJDBC.assertNull(resultSet.getObject("REMARKS"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(5));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(6));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_SCHEM"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(7));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_NAME"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(8));
        TestDuckDBJDBC.assertNull(resultSet.getObject("SELF_REFERENCING_COL_NAME"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(9));
        TestDuckDBJDBC.assertNull(resultSet.getObject("REF_GENERATION"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(10));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getTables(null, "main", "xxx", null);
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, null, "a", null);
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString("COLUMN_NAME"), "i");
        TestDuckDBJDBC.assertEquals(resultSet.getString(4), "i");
        TestDuckDBJDBC.assertEquals(resultSet.getInt("DATA_TYPE"), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getInt(5), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getString("TYPE_NAME"), "INTEGER");
        TestDuckDBJDBC.assertEquals(resultSet.getString(6), "INTEGER");
        TestDuckDBJDBC.assertNull(resultSet.getObject("COLUMN_SIZE"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(7));
        TestDuckDBJDBC.assertNull(resultSet.getObject("BUFFER_LENGTH"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(8));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, "main", "a", "i");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString("COLUMN_NAME"), "i");
        TestDuckDBJDBC.assertEquals(resultSet.getString(4), "i");
        TestDuckDBJDBC.assertEquals(resultSet.getInt("DATA_TYPE"), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getInt(5), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getString("TYPE_NAME"), "INTEGER");
        TestDuckDBJDBC.assertEquals(resultSet.getString(6), "INTEGER");
        TestDuckDBJDBC.assertNull(resultSet.getObject("COLUMN_SIZE"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(7));
        TestDuckDBJDBC.assertNull(resultSet.getObject("BUFFER_LENGTH"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(8));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getColumns(connection.getCatalog(), "main", "a", "i");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString("COLUMN_NAME"), "i");
        TestDuckDBJDBC.assertEquals(resultSet.getString(4), "i");
        TestDuckDBJDBC.assertEquals(resultSet.getInt("DATA_TYPE"), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getInt(5), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getString("TYPE_NAME"), "INTEGER");
        TestDuckDBJDBC.assertEquals(resultSet.getString(6), "INTEGER");
        TestDuckDBJDBC.assertNull(resultSet.getObject("COLUMN_SIZE"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(7));
        TestDuckDBJDBC.assertNull(resultSet.getObject("BUFFER_LENGTH"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(8));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, "xxx", "a", "i");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, "main", "xxx", "i");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, "main", "a", "xxx");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        connection.close();
    }

    public static void test_connect_wrong_url_bug848() throws Exception {
        DuckDBDriver duckDBDriver = new DuckDBDriver();
        TestDuckDBJDBC.assertNull(duckDBDriver.connect("jdbc:h2:", null));
    }

    public static void test_parquet_reader() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM parquet_scan('data/parquet-testing/userdata1.parquet')");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getInt(1), 1000);
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_crash_autocommit_bug939() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        PreparedStatement preparedStatement = connection.prepareStatement("CREATE TABLE ontime(flightdate DATE)");
        connection.setAutoCommit(false);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void test_explain_bug958() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("EXPLAIN SELECT 42");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertTrue(resultSet.getString(1) != null);
        TestDuckDBJDBC.assertTrue(resultSet.getString(2) != null);
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_appender_numbers() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE numbers (a BIGINT, b INTEGER, c SMALLINT, d TINYINT, e DOUBLE, f FLOAT)");
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "numbers");
        for (int i = 0; i < 50; ++i) {
            duckDBAppender.beginRow();
            duckDBAppender.append(Long.MAX_VALUE - (long)i);
            duckDBAppender.append(Integer.MAX_VALUE - i);
            duckDBAppender.append(Short.MAX_VALUE - i);
            duckDBAppender.append(127 - i);
            duckDBAppender.append(i);
            duckDBAppender.append(i);
            duckDBAppender.endRow();
        }
        duckDBAppender.close();
        ResultSet resultSet = statement.executeQuery("SELECT max(a), max(b), max(c), max(d), max(e), max(f) FROM numbers");
        TestDuckDBJDBC.assertFalse(resultSet.isClosed());
        TestDuckDBJDBC.assertTrue(resultSet.next());
        long l = resultSet.getLong(1);
        TestDuckDBJDBC.assertEquals(l, Long.MAX_VALUE);
        int n = resultSet.getInt(2);
        TestDuckDBJDBC.assertEquals(n, Integer.MAX_VALUE);
        short s = resultSet.getShort(3);
        TestDuckDBJDBC.assertEquals(s, (short)Short.MAX_VALUE);
        byte by = resultSet.getByte(4);
        TestDuckDBJDBC.assertEquals(by, (byte)127);
        double d = resultSet.getDouble(5);
        TestDuckDBJDBC.assertEquals(d, 49.0);
        float f = resultSet.getFloat(6);
        TestDuckDBJDBC.assertEquals(Float.valueOf(f), Float.valueOf(49.0f));
        resultSet.close();
        statement.close();
        duckDBConnection.close();
    }

    public static void test_appender_int_string() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE data (a INTEGER, s VARCHAR)");
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
        for (int i = 0; i < 1000; ++i) {
            duckDBAppender.beginRow();
            duckDBAppender.append(i);
            duckDBAppender.append("str " + i);
            duckDBAppender.endRow();
        }
        duckDBAppender.close();
        ResultSet resultSet = statement.executeQuery("SELECT max(a), min(s) FROM data");
        TestDuckDBJDBC.assertFalse(resultSet.isClosed());
        TestDuckDBJDBC.assertTrue(resultSet.next());
        int n = resultSet.getInt(1);
        TestDuckDBJDBC.assertEquals(n, 999);
        String string = resultSet.getString(2);
        TestDuckDBJDBC.assertEquals(string, "str 0");
        resultSet.close();
        statement.close();
        duckDBConnection.close();
    }

    public static void test_appender_table_does_not_exist() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        try {
            DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.close();
        duckDBConnection.close();
    }

    public static void test_appender_table_deleted() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE data (a INTEGER)");
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
        duckDBAppender.beginRow();
        duckDBAppender.append(1);
        duckDBAppender.endRow();
        statement.execute("DROP TABLE data");
        duckDBAppender.beginRow();
        duckDBAppender.append(2);
        duckDBAppender.endRow();
        try {
            duckDBAppender.close();
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.close();
        duckDBConnection.close();
    }

    public static void test_appender_append_too_many_columns() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE data (a INTEGER)");
        statement.close();
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
        try {
            duckDBAppender.beginRow();
            duckDBAppender.append(1);
            duckDBAppender.append(2);
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        duckDBConnection.close();
    }

    public static void test_appender_append_too_few_columns() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE data (a INTEGER, b INTEGER)");
        statement.close();
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
        try {
            duckDBAppender.beginRow();
            duckDBAppender.append(1);
            duckDBAppender.endRow();
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        duckDBConnection.close();
    }

    public static void test_appender_type_mismatch() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE data (a INTEGER)");
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
        try {
            duckDBAppender.beginRow();
            duckDBAppender.append("str");
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.close();
        duckDBConnection.close();
    }

    public static void test_get_catalog() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        ResultSet resultSet = duckDBConnection.getMetaData().getCatalogs();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        String string = resultSet.getString(1);
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        TestDuckDBJDBC.assertEquals(duckDBConnection.getCatalog(), string);
        duckDBConnection.close();
    }

    public static void test_get_table_types_bug1258() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE a1 (i INTEGER)");
        statement.execute("CREATE TABLE a2 (i INTEGER)");
        statement.execute("CREATE TEMPORARY TABLE b (i INTEGER)");
        statement.execute("CREATE VIEW c AS SELECT * FROM a1");
        statement.close();
        ResultSet resultSet = duckDBConnection.getMetaData().getTables(null, null, null, null);
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a1");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a2");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "b");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "c");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = duckDBConnection.getMetaData().getTables(null, null, null, new String[0]);
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a1");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a2");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "b");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "c");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = duckDBConnection.getMetaData().getTables(null, null, null, new String[]{"BASE TABLE"});
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a1");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a2");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = duckDBConnection.getMetaData().getTables(null, null, null, new String[]{"BASE TABLE", "VIEW"});
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a1");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a2");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "c");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = duckDBConnection.getMetaData().getTables(null, null, null, new String[]{"XXXX"});
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        duckDBConnection.close();
    }

    public static void test_utf_string_bug1271() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 'M\u00fchleisen', '\ud83e\udd86', '\ud83e\udd84\u0f80\u0f72123456789'");
        TestDuckDBJDBC.assertEquals(resultSet.getMetaData().getColumnName(1), "M\u00fchleisen");
        TestDuckDBJDBC.assertEquals(resultSet.getMetaData().getColumnName(2), "\ud83e\udd86");
        TestDuckDBJDBC.assertEquals(resultSet.getMetaData().getColumnName(3), "\ud83e\udd84\u0f80\u0f72123456789");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString(1), "M\u00fchleisen");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "\ud83e\udd86");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "\ud83e\udd84\u0f80\u0f72123456789");
        resultSet.close();
        statement.close();
        duckDBConnection.close();
    }

    public static void test_statement_creation_bug1268() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.close();
        statement = duckDBConnection.createStatement(1003, 1007);
        statement.close();
        statement = duckDBConnection.createStatement(1003, 1007, 0);
        statement.close();
        PreparedStatement preparedStatement = duckDBConnection.prepareStatement("SELECT 42");
        preparedStatement.close();
        preparedStatement = duckDBConnection.prepareStatement("SELECT 42", 1003, 1007);
        preparedStatement.close();
        preparedStatement = duckDBConnection.prepareStatement("SELECT 42", 1003, 1007, 0);
        preparedStatement.close();
        duckDBConnection.close();
    }

    public static void main(String[] stringArray) throws Exception {
        Method[] methodArray;
        for (Method method : methodArray = TestDuckDBJDBC.class.getMethods()) {
            if (!method.getName().startsWith("test_")) continue;
            method.invoke(null, new Object[0]);
        }
        System.out.println("OK");
    }

    static {
        try {
            Class.forName("org.duckdb.DuckDBDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }
}

