/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.wing;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.wing.AbstractWingTransformer;
import org.dspace.app.xmlui.wing.IncludePageMeta;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class IncludePageMeta
extends AbstractWingTransformer
implements CacheableProcessingComponent {
    private List<Metadata> metadataList;

    public Serializable getKey() {
        String key = "";
        for (Metadata metadata : this.metadataList) {
            key = "-" + metadata.getName() + "=" + metadata.getValue();
        }
        return Long.valueOf(HashUtil.hash((String)key));
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        try {
            String[] names = parameters.getNames();
            this.metadataList = new ArrayList();
            for (String name : names) {
                String[] nameParts = name.split("#");
                String dcName = null;
                int order = -1;
                switch (nameParts.length) {
                    case 1: {
                        dcName = nameParts[0];
                        order = 1;
                        break;
                    }
                    case 2: {
                        dcName = nameParts[0];
                        order = Integer.valueOf(nameParts[1]);
                        break;
                    }
                    default: {
                        throw new ProcessingException("Unable to parse page metadata name, '" + name + "', into parts.");
                    }
                }
                String[] dcParts = dcName.split("\\.");
                String element = null;
                String qualifier = null;
                String language = null;
                switch (dcParts.length) {
                    case 1: {
                        element = dcParts[0];
                        break;
                    }
                    case 2: {
                        element = dcParts[0];
                        qualifier = dcParts[1];
                        break;
                    }
                    case 3: {
                        element = dcParts[0];
                        qualifier = dcParts[1];
                        language = dcParts[2];
                        break;
                    }
                    default: {
                        throw new ProcessingException("Unable to parse page metadata name, '" + name + "', into parts.");
                    }
                }
                String value = parameters.getParameter(name);
                Metadata metadata = new Metadata(element, qualifier, language, order, value);
                this.metadataList.add(metadata);
            }
            Collections.sort(this.metadataList);
        }
        catch (ParameterException pe) {
            throw new ProcessingException((Exception)((Object)pe));
        }
        try {
            this.setupWing();
        }
        catch (WingException we) {
            throw new ProcessingException((Exception)((Object)we));
        }
        if (DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("xmlui.theme.enableConcatenation", false)) {
            this.metadataList = this.enableConcatenation();
        }
    }

    private List<Metadata> enableConcatenation() {
        Metadata last = null;
        ArrayList<Metadata> newMetadataList = new ArrayList<Metadata>();
        for (Metadata metadata : this.metadataList) {
            String curfile = metadata.getValue();
            if (curfile.lastIndexOf(63) != -1) {
                curfile = curfile.substring(0, curfile.lastIndexOf(63));
            }
            if (curfile.endsWith(".css") || curfile.endsWith(".js") || curfile.endsWith(".json")) {
                String curval = metadata.getValue();
                if (last != null && this.checkConcatenateMerge(last, metadata)) {
                    String lastval = last.getValue();
                    curval = metadata.getValue();
                    String newval = lastval.substring(0, lastval.lastIndexOf(46)) + ",";
                    newval = newval + curval.substring(curval.lastIndexOf(47) + 1, curval.lastIndexOf(46));
                    newval = newval + lastval.substring(lastval.lastIndexOf(46));
                    Metadata.access$002((Metadata)last, (String)newval);
                    continue;
                }
                newMetadataList.add(metadata);
                if (curval.lastIndexOf(63) != -1) {
                    if (curval.substring(curval.lastIndexOf(63)).equals("?nominify")) {
                        last = metadata;
                        continue;
                    }
                    if (curval.substring(curval.lastIndexOf(63)).equals("?noconcat")) {
                        last = null;
                        curval = curval.substring(0, curval.lastIndexOf(63));
                        Metadata.access$002((Metadata)metadata, (String)curval);
                        continue;
                    }
                    last = null;
                    curval = curval.substring(0, curval.lastIndexOf(63)) + "?nominify";
                    Metadata.access$002((Metadata)metadata, (String)curval);
                    continue;
                }
                last = metadata;
                continue;
            }
            newMetadataList.add(metadata);
        }
        return newMetadataList;
    }

    private boolean checkConcatenateMerge(Metadata last, Metadata current) {
        if (last.getElement() == null ? current.getElement() != null : !last.getElement().equals(current.getElement())) {
            return false;
        }
        if (last.getQualifier() == null ? current.getQualifier() != null : !last.getQualifier().equals(current.getQualifier())) {
            return false;
        }
        if (last.getLanguage() == null ? current.getLanguage() != null : !last.getLanguage().equals(current.getLanguage())) {
            return false;
        }
        String curval = current.getValue();
        String lastval = last.getValue();
        if (!lastval.substring(lastval.lastIndexOf(46)).equals(curval.substring(curval.lastIndexOf(46)))) {
            return false;
        }
        if (!lastval.substring(0, lastval.lastIndexOf(47) + 1).equals(curval.substring(0, curval.lastIndexOf(47) + 1))) {
            return false;
        }
        return curval.lastIndexOf(63) == -1 || "?nominify".equals(curval.substring(curval.lastIndexOf(63)));
    }

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        for (Metadata metadata : this.metadataList) {
            String element = metadata.getElement();
            String qualifier = metadata.getQualifier();
            String language = metadata.getLanguage();
            String value = metadata.getValue();
            pageMeta.addMetadata(element, qualifier, language).addContent(value);
        }
    }
}

