/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.utils;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;

/*
 * Exception performing whole class analysis ignored.
 */
public class HandleUtil {
    protected static final String HANDLE_PREFIX = "handle/";
    protected static final String DSPACE_OBJECT = "dspace.object";
    protected static final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    public static DSpaceObject obtainHandle(Map objectModel) throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        DSpaceObject dso = (DSpaceObject)request.getAttribute("dspace.object");
        Context context = ContextUtil.obtainContext((Map)objectModel);
        if (dso == null) {
            String uri = request.getSitemapURI();
            if (!uri.startsWith("handle/")) {
                return null;
            }
            String handle = uri.substring("handle/".length());
            int firstSlash = handle.indexOf(47);
            if (firstSlash < 0) {
                return null;
            }
            int secondSlash = handle.indexOf(47, firstSlash + 1);
            if (secondSlash < 0) {
                secondSlash = handle.length();
            }
            handle = handle.substring(0, secondSlash);
            dso = handleService.resolveToObject(context, handle);
            request.setAttribute("dspace.object", (Object)dso);
        }
        return (DSpaceObject)context.reloadEntity((ReloadableEntity)dso);
    }

    public static boolean inheritsFrom(DSpaceObject dso, String parent) throws SQLException {
        DSpaceObject current = dso;
        while (current != null) {
            if (current.getHandle().equals(parent)) {
                return true;
            }
            if (current.getType() == 2) {
                current = ((Item)current).getOwningCollection();
                continue;
            }
            if (current.getType() == 3) {
                current = (DSpaceObject)((org.dspace.content.Collection)current).getCommunities().get(0);
                continue;
            }
            if (current.getType() != 4) continue;
            List parents = ((Community)current).getParentCommunities();
            current = CollectionUtils.isNotEmpty((Collection)parents) ? (Community)parents.get(0) : null;
        }
        return false;
    }

    public static void buildHandleTrail(Context context, DSpaceObject dso, PageMeta pageMeta, String contextPath) throws SQLException, WingException {
        HandleUtil.buildHandleTrail((Context)context, (DSpaceObject)dso, (PageMeta)pageMeta, (String)contextPath, (boolean)false);
    }

    public static void buildHandleTrail(Context context, DSpaceObject dso, PageMeta pageMeta, String contextPath, boolean linkOriginalObject) throws SQLException, WingException {
        Stack<Object> stack = new Stack<Object>();
        DSpaceObject aDso = dso;
        if (aDso instanceof Bitstream) {
            Bitstream bitstream = (Bitstream)aDso;
            List bundles = bitstream.getBundles();
            aDso = (DSpaceObject)bundles.get(0);
        }
        if (aDso instanceof Bundle) {
            Bundle bundle = (Bundle)aDso;
            List items = bundle.getItems();
            aDso = (DSpaceObject)items.get(0);
        }
        if (aDso instanceof Item) {
            Item item = (Item)aDso;
            org.dspace.content.Collection collection = item.getOwningCollection();
            aDso = collection;
        }
        if (aDso instanceof org.dspace.content.Collection) {
            org.dspace.content.Collection collection = (org.dspace.content.Collection)aDso;
            stack.push(collection);
            List communities = collection.getCommunities();
            aDso = (DSpaceObject)communities.get(0);
        }
        if (aDso instanceof Community) {
            Community community = (Community)aDso;
            stack.push(community);
            for (Community parent : communityService.getAllParents(context, community)) {
                stack.push(parent);
            }
        }
        while (!stack.empty()) {
            String name;
            DSpaceObject pop = (DSpaceObject)stack.pop();
            String target = pop == dso && !linkOriginalObject ? null : contextPath + "/handle/" + pop.getHandle();
            if (pop instanceof org.dspace.content.Collection) {
                org.dspace.content.Collection collection = (org.dspace.content.Collection)pop;
                name = collection.getName();
                if (name == null || name.length() == 0) {
                    pageMeta.addTrailLink(target, new Message("default", "xmlui.general.untitled"));
                    continue;
                }
                pageMeta.addTrailLink(target, name);
                continue;
            }
            if (!(pop instanceof Community)) continue;
            Community community = (Community)pop;
            name = community.getName();
            if (name == null || name.length() == 0) {
                pageMeta.addTrailLink(target, new Message("default", "xmlui.general.untitled"));
                continue;
            }
            pageMeta.addTrailLink(target, name);
        }
    }
}

