/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;

/*
 * Exception performing whole class analysis ignored.
 */
public class UsageLoggerAction
extends AbstractAction {
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    public Map act(Redirector redirector, SourceResolver sourceResolver, Map objectModel, String string, Parameters parameters) throws Exception {
        try {
            Request request = ObjectModelHelper.getRequest((Map)objectModel);
            Context context = ContextUtil.obtainContext((Map)objectModel);
            DSpaceObject dso = HandleUtil.obtainHandle((Map)objectModel);
            if (dso == null) {
                dso = this.findBitstream(context, parameters);
            }
            UsageLoggerAction.logDspaceObject((Request)request, (DSpaceObject)dso, (Context)context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void logDspaceObject(Request request, DSpaceObject dso, Context context) {
        if (dso == null) {
            return;
        }
        try {
            DSpaceServicesFactory.getInstance().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, (HttpServletRequest)request, ContextUtil.obtainContext((HttpServletRequest)request), dso));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Bitstream findBitstream(Context context, Parameters par) throws SQLException {
        DSpaceObject dso;
        String itemID = par.getParameter("itemID", null);
        String bitstreamID = par.getParameter("bitstreamID", null);
        String handle = par.getParameter("handle", null);
        int sequence = par.getParameterAsInteger("sequence", -1);
        String name = par.getParameter("name", null);
        Bitstream bitstream = null;
        if (bitstreamID != null) {
            bitstream = (Bitstream)this.bitstreamService.find(context, UUID.fromString(bitstreamID));
        } else if (itemID != null) {
            Item item = (Item)this.itemService.find(context, UUID.fromString(itemID));
            if (sequence > -1) {
                bitstream = this.findBitstreamBySequence(item, sequence);
            } else if (name != null) {
                bitstream = this.findBitstreamByName(item, name);
            }
        } else if (handle != null && (dso = this.handleService.resolveToObject(context, handle)) instanceof Item) {
            Item item = (Item)dso;
            if (sequence > -1) {
                bitstream = this.findBitstreamBySequence(item, sequence);
            } else if (name != null) {
                bitstream = this.findBitstreamByName(item, name);
            }
        }
        return bitstream;
    }

    private Bitstream findBitstreamBySequence(Item item, int sequence) throws SQLException {
        if (item == null) {
            return null;
        }
        List bundles = item.getBundles();
        for (Bundle bundle : bundles) {
            List bitstreams = bundle.getBitstreams();
            for (Bitstream bitstream : bitstreams) {
                if (bitstream.getSequenceID() != sequence) continue;
                return bitstream;
            }
        }
        return null;
    }

    private Bitstream findBitstreamByName(Item item, String name) throws SQLException {
        if (name == null || item == null) {
            return null;
        }
        int maxDepthPathSearch = 3;
        if (DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("xmlui.html.max-depth-guess") != null) {
            maxDepthPathSearch = DSpaceServicesFactory.getInstance().getConfigurationService().getIntProperty("xmlui.html.max-depth-guess");
        }
        for (int i = 0; i < maxDepthPathSearch + 1; ++i) {
            int indexOfLastSlash;
            List bundles = item.getBundles();
            for (Bundle bundle : bundles) {
                List bitstreams = bundle.getBitstreams();
                for (Bitstream bitstream : bitstreams) {
                    if (!name.equals(bitstream.getName())) continue;
                    return bitstream;
                }
            }
            int indexOfSlash = name.indexOf(47);
            if (indexOfSlash < 0) {
                return null;
            }
            name = name.substring(indexOfSlash + 1);
            if (i != maxDepthPathSearch - 1 || (indexOfLastSlash = name.lastIndexOf(47)) <= -1) continue;
            name = name.substring(indexOfLastSlash + 1);
        }
        return null;
    }
}

