/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.log4j.Logger;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.MetadataExport;
import org.dspace.app.xmlui.utils.AuthenticationUtil;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.xml.sax.SAXException;

public class MetadataExportReader
extends AbstractReader
implements Recyclable {
    private static final String AUTH_REQUIRED_HEADER = "xmlui.ItemExportDownloadReader.auth_header";
    private static final String AUTH_REQUIRED_MESSAGE = "xmlui.ItemExportDownloadReader.auth_message";
    protected static final int BUFFER_SIZE = 8192;
    protected static final int expires = 216000000;
    protected Response response;
    protected Request request;
    private static Logger log = Logger.getLogger(MetadataExportReader.class);
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    DSpaceCSV csv = null;
    MetadataExport exporter = null;
    String filename = null;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            String handle;
            this.request = ObjectModelHelper.getRequest((Map)objectModel);
            this.response = ObjectModelHelper.getResponse((Map)objectModel);
            Context context = ContextUtil.obtainContext((Map)objectModel);
            if (this.authorizeService.isAdmin(context)) {
                handle = par.getParameter("handle");
                DSpaceObject dso = this.handleService.resolveToObject(context, handle);
                ArrayList<DSpaceObject> itemmd = new ArrayList<DSpaceObject>();
                if (dso.getType() == 2) {
                    itemmd.add(this.itemService.find(context, dso.getID()));
                    this.exporter = new MetadataExport(context, itemmd.iterator(), false);
                } else if (dso.getType() == 3) {
                    Collection collection = (Collection)dso;
                    Iterator toExport = this.itemService.findByCollection(context, collection);
                    this.exporter = new MetadataExport(context, toExport, false);
                } else if (dso.getType() == 4) {
                    this.exporter = new MetadataExport(context, (Community)dso, false);
                }
            } else {
                if (AuthenticationUtil.isLoggedIn((HttpServletRequest)this.request)) {
                    String redictURL = this.request.getContextPath() + "/restricted-resource";
                    HttpServletResponse httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
                    httpResponse.sendRedirect(redictURL);
                    return;
                }
                String redictURL = this.request.getContextPath() + "/login";
                AuthenticationUtil.interruptRequest((Map)objectModel, (String)AUTH_REQUIRED_HEADER, (String)AUTH_REQUIRED_MESSAGE, null);
                HttpServletResponse httpResponse = (HttpServletResponse)objectModel.get("httpresponse");
                httpResponse.sendRedirect(redictURL);
                return;
            }
            log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)("exporting_handle:" + handle)));
            this.csv = this.exporter.export();
            this.filename = handle.replaceAll("/", "-") + ".csv";
            log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)("exported_file:" + this.filename)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to read bitstream.", (Throwable)e);
        }
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.response.setContentType("text/csv; charset=UTF-8");
        this.response.setHeader("Content-Disposition", "attachment; filename=" + this.filename);
        this.out.write(this.csv.toString().getBytes("UTF-8"));
        this.out.flush();
        this.out.close();
    }

    public void recycle() {
        this.response = null;
        this.request = null;
        this.exporter = null;
        this.filename = null;
        this.csv = null;
        super.recycle();
    }
}

