/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.content.Collection;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.ChoicesXMLGenerator;
import org.dspace.content.authority.factory.ContentAuthorityServiceFactory;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AJAXMenuGenerator
extends AbstractGenerator {
    private static Logger log = Logger.getLogger(AJAXMenuGenerator.class);
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ChoiceAuthorityService choiceAuthorityService = ContentAuthorityServiceFactory.getInstance().getChoiceAuthorityService();

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            String scoll;
            String slimit;
            int start = 0;
            int limit = 1000;
            Collection collection = null;
            String format = this.parameters.getParameter("format", null);
            String field = this.parameters.getParameter("field", null);
            String sstart = this.parameters.getParameter("start", null);
            if (sstart != null && sstart.length() > 0) {
                start = Integer.parseInt(sstart);
            }
            if ((slimit = this.parameters.getParameter("limit", null)) != null && slimit.length() > 0) {
                limit = Integer.parseInt(slimit);
            }
            if ((scoll = this.parameters.getParameter("collection", null)) != null && scoll.length() > 0) {
                collection = (Collection)this.collectionService.find(ContextUtil.obtainContext((HttpServletRequest)ObjectModelHelper.getRequest((Map)this.objectModel)), UUID.fromString(scoll));
            }
            String query = this.parameters.getParameter("query", null);
            String locale = this.parameters.getParameter("locale", null);
            log.debug((Object)("AJAX menu generator: field=" + field + ", query=" + query + ", start=" + sstart + ", limit=" + slimit + ", format=" + format + ", field=" + field + ", query=" + query + ", start=" + sstart + ", limit=" + slimit + ", format=" + format + ", locale = " + locale));
            Choices result = this.choiceAuthorityService.getMatches(field, query, collection, start, limit, locale, true);
            log.debug((Object)("Result count = " + result.values.length + ", default=" + result.defaultSelected));
            ChoicesXMLGenerator.generate((Choices)result, (String)format, (ContentHandler)this.contentHandler);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

