/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.xmlworkflow;

import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.service.WorkflowRequirementsService;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;

public class UnclaimTasksAction
extends AbstractAction {
    private static final Logger log = Logger.getLogger(UnclaimTasksAction.class);
    protected ClaimedTaskService claimedTaskService = XmlWorkflowServiceFactory.getInstance().getClaimedTaskService();
    protected XmlWorkflowItemService xmlWorkflowItemService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowItemService();
    protected XmlWorkflowService xmlWorkflowService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService();
    protected WorkflowRequirementsService workflowRequirementsService = XmlWorkflowServiceFactory.getInstance().getWorkflowRequirementsService();

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Context context = ContextUtil.obtainContext((Map)objectModel);
        String[] workflowIDs = request.getParameterValues("workflowandstepID");
        if (workflowIDs != null) {
            for (String workflowID : workflowIDs) {
                XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowItemService.find(context, Integer.valueOf(workflowID.split(":")[0]).intValue());
                ClaimedTask pooledTask = this.claimedTaskService.findByWorkflowIdAndEPerson(context, workflowItem, context.getCurrentUser());
                this.xmlWorkflowService.deleteClaimedTask(context, workflowItem, pooledTask);
                this.workflowRequirementsService.removeClaimedUser(context, workflowItem, context.getCurrentUser(), workflowID.split(":")[1]);
                log.info((Object)LogManager.getHeader((Context)context, (String)"unclaim_workflow", (String)("workflow_id=" + workflowItem.getID())));
            }
        }
        return null;
    }
}

