/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.eperson;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.app.xmlui.wing.element.UserMeta;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

public class Navigation
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_my_account = Navigation.message((String)"xmlui.EPerson.Navigation.my_account");
    private static final Message T_profile = Navigation.message((String)"xmlui.EPerson.Navigation.profile");
    private static final Message T_logout = Navigation.message((String)"xmlui.EPerson.Navigation.logout");
    private static final Message T_login = Navigation.message((String)"xmlui.EPerson.Navigation.login");
    private static final Message T_register = Navigation.message((String)"xmlui.EPerson.Navigation.register");
    private SourceValidity validity;
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    public Serializable getKey() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        if (request.getParameter("login_email") != null || request.getParameter("login_password") != null || request.getParameter("login_realm") != null) {
            return null;
        }
        if (request.getSitemapURI().length() == 0) {
            return null;
        }
        StringBuilder key = this.context.getCurrentUser() != null ? new StringBuilder(this.context.getCurrentUser().getEmail()) : new StringBuilder("anonymous");
        Enumeration locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            key.append("-").append(locale.toString());
        }
        return Long.valueOf(HashUtil.hash((String)key.toString()));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            if (this.context.getCurrentUser() != null) {
                try {
                    DSpaceValidity validity = new DSpaceValidity();
                    validity.add(this.context, (DSpaceObject)this.eperson);
                    Set groups = this.groupService.allMemberGroupsSet(this.context, this.eperson);
                    for (Group group : groups) {
                        validity.add(this.context, (DSpaceObject)group);
                    }
                    this.validity = validity.complete();
                }
                catch (SQLException sQLException) {}
            } else {
                this.validity = NOPValidity.SHARED_INSTANCE;
            }
        }
        return this.validity;
    }

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        options.addList("browse");
        List account = options.addList("account");
        options.addList("context");
        options.addList("administrative");
        account.setHead(T_my_account);
        EPerson eperson = this.context.getCurrentUser();
        if (eperson != null) {
            String fullName = eperson.getFullName();
            account.addItemXref(this.contextPath + "/logout", T_logout);
            account.addItemXref(this.contextPath + "/profile", T_profile.parameterize(new Object[]{fullName}));
        } else {
            account.addItemXref(this.contextPath + "/login", T_login);
            if (DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("xmlui.user.registration", true)) {
                account.addItemXref(this.contextPath + "/register", T_register);
            }
        }
    }

    public void addUserMeta(UserMeta userMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        EPerson eperson = this.context.getCurrentUser();
        if (eperson != null) {
            userMeta.setAuthenticated(true);
            userMeta.addMetadata("identifier").addContent(eperson.getID().toString());
            userMeta.addMetadata("identifier", "email").addContent(eperson.getEmail());
            userMeta.addMetadata("identifier", "firstName").addContent(eperson.getFirstName());
            userMeta.addMetadata("identifier", "lastName").addContent(eperson.getLastName());
            userMeta.addMetadata("identifier", "logoutURL").addContent(this.contextPath + "/logout");
            userMeta.addMetadata("identifier", "url").addContent(this.contextPath + "/profile");
        } else {
            userMeta.setAuthenticated(false);
        }
        userMeta.addMetadata("identifier", "loginURL").addContent(this.contextPath + "/login");
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Enumeration locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            userMeta.addMetadata("language", "RFC3066").addContent(locale.toString());
        }
    }

    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

