/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.discovery;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

public class CollectionSearch
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_dspace_home = CollectionSearch.message((String)"xmlui.general.dspace_home");
    private static final Message T_full_text_search = CollectionSearch.message((String)"xmlui.ArtifactBrowser.CollectionViewer.full_text_search");
    private static final Message T_go = CollectionSearch.message((String)"xmlui.general.go");
    public static final Message T_untitled = CollectionSearch.message((String)"xmlui.general.untitled");
    private SourceValidity validity;

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            Collection collection = null;
            try {
                DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
                if (dso == null) {
                    return null;
                }
                if (!(dso instanceof Collection)) {
                    return null;
                }
                collection = (Collection)dso;
                DSpaceValidity validity = new DSpaceValidity();
                validity.add(this.context, (DSpaceObject)collection);
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dso instanceof Collection)) {
            return;
        }
        Collection collection = (Collection)dso;
        String name = collection.getName();
        if (name == null || name.length() == 0) {
            pageMeta.addMetadata("title").addContent(T_untitled);
        } else {
            pageMeta.addMetadata("title").addContent(name);
        }
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        HandleUtil.buildHandleTrail((Context)this.context, (DSpaceObject)collection, (PageMeta)pageMeta, (String)this.contextPath);
        String[] formats = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("webui.feed.formats");
        if (formats != null) {
            for (String format : formats) {
                String[] parts = format.split("_");
                if (parts.length < 1) continue;
                String feedFormat = parts[0].trim() + "+xml";
                String feedURL = this.contextPath + "/feed/" + format.trim() + "/" + collection.getHandle();
                pageMeta.addMetadata("feed", feedFormat).addContent(feedURL);
            }
        }
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle((Map)this.objectModel);
        if (!(dso instanceof Collection)) {
            return;
        }
        Collection collection = (Collection)dso;
        Division home = body.addDivision("collection-home", "primary repository collection");
        String name = collection.getName();
        if (name == null || name.length() == 0) {
            home.setHead(T_untitled);
        } else {
            home.setHead(name);
        }
        Division search = home.addDivision("collection-search-browse", "secondary search-browse");
        Division query = search.addInteractiveDivision("collection-search", this.contextPath + "/handle/" + collection.getHandle() + "/discover", "post", "secondary search");
        Para para = query.addPara("search-query", null);
        para.addContent(T_full_text_search);
        para.addContent(" ");
        para.addText("query");
        para.addContent(" ");
        para.addButton("submit").setValue(T_go);
    }

    public void recycle() {
        this.validity = null;
        super.recycle();
    }
}

