/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.artifactbrowser.CommunityBrowser;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Reference;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.ItemCountException;
import org.dspace.browse.ItemCounter;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.xml.sax.SAXException;

public class CommunityBrowser
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(CommunityBrowser.class);
    public static final Message T_dspace_home = CommunityBrowser.message((String)"xmlui.general.dspace_home");
    public static final Message T_title = CommunityBrowser.message((String)"xmlui.ArtifactBrowser.CommunityBrowser.title");
    public static final Message T_trail = CommunityBrowser.message((String)"xmlui.ArtifactBrowser.CommunityBrowser.trail");
    public static final Message T_head = CommunityBrowser.message((String)"xmlui.ArtifactBrowser.CommunityBrowser.head");
    public static final Message T_select = CommunityBrowser.message((String)"xmlui.ArtifactBrowser.CommunityBrowser.select");
    protected boolean excludeCollections = false;
    private static final int DEFAULT_DEPTH = 999;
    protected int depth = 999;
    protected TreeNode root;
    private SourceValidity validity;
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private ItemCounter itemCounter = null;
    private boolean showCount = this.configurationService.getBooleanProperty("webui.strengths.show");

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.depth = parameters.getParameterAsInteger("depth", 999);
        this.excludeCollections = parameters.getParameterAsBoolean("exclude-collections", false);
        if (this.showCount) {
            try {
                this.itemCounter = new ItemCounter(this.context);
            }
            catch (ItemCountException e) {
                log.error((Object)e);
            }
        }
    }

    public Serializable getKey() {
        boolean full = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("xmlui.community-list.render.full", true);
        return Long.valueOf(HashUtil.hash((String)(this.depth + "-" + this.excludeCollections + "-" + (full ? "true" : "false"))));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                Context.Mode originalMode = this.context.getCurrentMode();
                this.context.setMode(Context.Mode.READ_ONLY);
                DSpaceValidity theValidity = new DSpaceValidity();
                TreeNode treeRoot = this.buildTree(this.communityService.findAllTop(this.context));
                Stack<TreeNode> stack = new Stack<TreeNode>();
                stack.push(treeRoot);
                while (!stack.empty()) {
                    TreeNode node = (TreeNode)stack.pop();
                    theValidity.add(this.context, node.getDSO());
                    if (this.showCount) {
                        try {
                            int size = this.itemCounter.getCount(node.getDSO());
                            theValidity.add("size:" + size);
                        }
                        catch (ItemCountException itemCountException) {
                            // empty catch block
                        }
                    }
                    for (TreeNode child : node.getChildren()) {
                        stack.push(child);
                    }
                }
                String assumeCacheValidity = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("xmlui.community-list.cache");
                if (assumeCacheValidity != null) {
                    theValidity.setAssumedValidityDelay(assumeCacheValidity);
                }
                this.validity = theValidity.complete();
                this.context.setMode(originalMode);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            log.info((Object)LogManager.getHeader((Context)this.context, (String)"view_community_list", (String)""));
        }
        return this.validity;
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Division division = body.addDivision("comunity-browser", "primary");
        division.setHead(T_head);
        division.addPara(T_select);
        Context.Mode originalMode = this.context.getCurrentMode();
        this.context.setMode(Context.Mode.READ_ONLY);
        TreeNode treeRoot = this.buildTree(this.communityService.findAllTop(this.context));
        boolean full = DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("xmlui.community-list.render.full", true);
        if (full) {
            ReferenceSet referenceSet = division.addReferenceSet("community-browser", "summaryList", null, "hierarchy");
            List rootNodes = treeRoot.getChildrenOfType(4);
            for (TreeNode node : rootNodes) {
                this.buildReferenceSet(referenceSet, node);
            }
        } else {
            org.dspace.app.xmlui.wing.element.List list = division.addList("comunity-browser");
            List rootNodes = treeRoot.getChildrenOfType(4);
            for (TreeNode node : rootNodes) {
                this.buildList(list, node);
            }
        }
        this.context.setMode(originalMode);
    }

    public void buildReferenceSet(ReferenceSet referenceSet, TreeNode node) throws WingException {
        List communityNodes;
        DSpaceObject dso = node.getDSO();
        Reference objectInclude = referenceSet.addReference((Object)dso);
        List collectionNodes = node.getChildrenOfType(3);
        if (collectionNodes != null && collectionNodes.size() > 0) {
            ReferenceSet collectionSet = objectInclude.addReferenceSet("summaryList");
            for (TreeNode collectionNode : collectionNodes) {
                collectionSet.addReference((Object)collectionNode.getDSO());
            }
        }
        if ((communityNodes = node.getChildrenOfType(4)) != null && communityNodes.size() > 0) {
            ReferenceSet communitySet = objectInclude.addReferenceSet("summaryList");
            for (TreeNode communityNode : communityNodes) {
                this.buildReferenceSet(communitySet, communityNode);
            }
        }
    }

    public void buildList(org.dspace.app.xmlui.wing.element.List list, TreeNode node) throws WingException {
        List communityNodes;
        DSpaceObject dso = node.getDSO();
        String name = null;
        if (dso instanceof Community) {
            name = ((Community)dso).getName();
        } else if (dso instanceof Collection) {
            name = ((Collection)dso).getName();
        }
        String aURL = this.contextPath + "/handle/" + dso.getHandle();
        list.addItem().addHighlight("bold").addXref(aURL, name);
        org.dspace.app.xmlui.wing.element.List subList = null;
        List collectionNodes = node.getChildrenOfType(3);
        if (collectionNodes != null && collectionNodes.size() > 0) {
            subList = list.addList("sub-list-" + dso.getID());
            for (TreeNode collectionNode : collectionNodes) {
                String collectionName = ((Collection)collectionNode.getDSO()).getName();
                String collectionUrl = this.contextPath + "/handle/" + collectionNode.getDSO().getHandle();
                subList.addItemXref(collectionUrl, collectionName);
            }
        }
        if ((communityNodes = node.getChildrenOfType(4)) != null && communityNodes.size() > 0) {
            if (subList == null) {
                subList = list.addList("sub-list-" + dso.getID());
            }
            for (TreeNode communityNode : communityNodes) {
                this.buildList(subList, communityNode);
            }
        }
    }

    public void recycle() {
        this.root = null;
        this.validity = null;
        super.recycle();
    }

    private TreeNode buildTree(List<Community> communities) throws SQLException {
        if (this.root != null) {
            return this.root;
        }
        TreeNode newRoot = new TreeNode();
        Stack<TreeNode> stack = new Stack<TreeNode>();
        for (Community community : communities) {
            stack.push(newRoot.addChild((DSpaceObject)community));
        }
        while (!stack.empty()) {
            Community community;
            TreeNode node = (TreeNode)stack.pop();
            if (node.getLevel() >= this.depth) continue;
            community = (Community)node.getDSO();
            for (Community subcommunity : community.getSubcommunities()) {
                stack.push(node.addChild((DSpaceObject)subcommunity));
            }
            if (this.excludeCollections) continue;
            for (Collection collection : community.getCollections()) {
                node.addChild((DSpaceObject)collection);
            }
        }
        this.root = newRoot;
        return this.root;
    }
}

