/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.registries;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataSchema;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataSchemaService;

public class DeleteMetadataSchemaConfirm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = DeleteMetadataSchemaConfirm.message((String)"xmlui.general.dspace_home");
    private static final Message T_title = DeleteMetadataSchemaConfirm.message((String)"xmlui.administrative.registries.DeleteMetadataSchemaConfirm.title");
    private static final Message T_metadata_registry_trail = DeleteMetadataSchemaConfirm.message((String)"xmlui.administrative.registries.general.metadata_registry_trail");
    private static final Message T_trail = DeleteMetadataSchemaConfirm.message((String)"xmlui.administrative.registries.DeleteMetadataSchemaConfirm.trail");
    private static final Message T_head = DeleteMetadataSchemaConfirm.message((String)"xmlui.administrative.registries.DeleteMetadataSchemaConfirm.head");
    private static final Message T_para1 = DeleteMetadataSchemaConfirm.message((String)"xmlui.administrative.registries.DeleteMetadataSchemaConfirm.para1");
    private static final Message T_warning = DeleteMetadataSchemaConfirm.message((String)"xmlui.administrative.registries.DeleteMetadataSchemaConfirm.warning");
    private static final Message T_para2 = DeleteMetadataSchemaConfirm.message((String)"xmlui.administrative.registries.DeleteMetadataSchemaConfirm.para2");
    private static final Message T_column1 = DeleteMetadataSchemaConfirm.message((String)"xmlui.administrative.registries.DeleteMetadataSchemaConfirm.column1");
    private static final Message T_column2 = DeleteMetadataSchemaConfirm.message((String)"xmlui.administrative.registries.DeleteMetadataSchemaConfirm.column2");
    private static final Message T_column3 = DeleteMetadataSchemaConfirm.message((String)"xmlui.administrative.registries.DeleteMetadataSchemaConfirm.column3");
    private static final Message T_submit_delete = DeleteMetadataSchemaConfirm.message((String)"xmlui.general.delete");
    private static final Message T_submit_cancel = DeleteMetadataSchemaConfirm.message((String)"xmlui.general.cancel");
    protected MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/metadata-registry", T_metadata_registry_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        String idsString = this.parameters.getParameter("schemaIDs", null);
        ArrayList<MetadataSchema> schemas = new ArrayList<MetadataSchema>();
        for (String id : idsString.split(",")) {
            MetadataSchema schema = this.metadataSchemaService.find(this.context, Integer.valueOf(id).intValue());
            schemas.add(schema);
        }
        Division deleted = body.addInteractiveDivision("metadata-schema-confirm-delete", this.contextPath + "/admin/metadata-registry", "post", "primary administrative metadata-registry");
        deleted.setHead(T_head);
        deleted.addPara(T_para1);
        Para warning = deleted.addPara();
        warning.addHighlight("bold").addContent(T_warning);
        warning.addContent(T_para2);
        Table table = deleted.addTable("schema-confirm-delete", schemas.size() + 1, 3);
        Row header = table.addRow("header");
        header.addCell().addContent(T_column1);
        header.addCell().addContent(T_column2);
        header.addCell().addContent(T_column3);
        for (MetadataSchema schema : schemas) {
            Row row = table.addRow();
            row.addCell().addContent(schema.getID().intValue());
            row.addCell().addContent(schema.getNamespace());
            row.addCell().addContent(schema.getName());
        }
        Para buttons = deleted.addPara();
        buttons.addButton("submit_confirm").setValue(T_submit_delete);
        buttons.addButton("submit_cancel").setValue(T_submit_cancel);
        deleted.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

